/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro.mappers;

import io.simplesource.kafka.serialization.avro.mappers.DomainMapperRegistry;
import io.simplesource.kafka.serialization.util.GenericMapper;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;

public final class RegistryBasedDomainMapper<V, S extends GenericRecord>
implements GenericMapper<V, S> {
    private final DomainMapperRegistry domainMapperRegistry;
    private final GenericMapper<S, GenericRecord> avroSpecificGenericMapper;
    private final Function<V, Class<?>> domainValueToTypeFunct;
    private Supplier<? extends RuntimeException> exceptionSupplier;

    RegistryBasedDomainMapper(DomainMapperRegistry domainMapperRegistry, GenericMapper<S, GenericRecord> avroSpecificGenericMapper, Function<V, Class<?>> domainValueToType) {
        this.domainMapperRegistry = domainMapperRegistry;
        this.avroSpecificGenericMapper = avroSpecificGenericMapper;
        this.domainValueToTypeFunct = domainValueToType;
        this.exceptionSupplier = () -> new IllegalArgumentException("Class not supported");
    }

    @Override
    public S toGeneric(V value) {
        return (S)((GenericRecord)this.lookupMapperInRegistry(this.domainValueToTypeFunct.apply(value)).fromDomainFunc().apply(value));
    }

    @Override
    public V fromGeneric(S serialized) {
        GenericRecord specificRecord = (GenericRecord)this.avroSpecificGenericMapper.fromGeneric((GenericRecord)serialized);
        return this.lookupMapperInRegistry(specificRecord.getClass()).toDomainFunc().apply(specificRecord);
    }

    void withExceptionSupplier(Supplier<? extends RuntimeException> exceptionSupplier) {
        this.exceptionSupplier = exceptionSupplier;
    }

    private DomainMapperRegistry.RegisterMapper<V, S> lookupMapperInRegistry(Class<?> typeClass) {
        Optional registryMapper = this.domainMapperRegistry.mapperFor(typeClass);
        return registryMapper.orElseThrow(this.exceptionSupplier);
    }
}

