/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.simplesource.kafka.serialization.util.GenericMapper;
import java.util.Objects;
import java.util.Optional;

public final class JsonOptionalGenericMapper<D>
implements GenericMapper<Optional<D>, JsonElement> {
    private static final String VALUE = "value";
    private static final String CLASS = "class";
    private final Gson gson = new Gson();
    private static final JsonOptionalGenericMapper INSTANCE = new JsonOptionalGenericMapper();

    private JsonOptionalGenericMapper() {
    }

    @Override
    public JsonElement toGeneric(Optional<D> value) {
        JsonObject wrapper = new JsonObject();
        wrapper.add(VALUE, this.gson.toJsonTree(value.orElse(null)));
        wrapper.addProperty(CLASS, (String)value.map(o -> o.getClass().getName()).orElse(null));
        return wrapper;
    }

    @Override
    public Optional<D> fromGeneric(JsonElement serialized) {
        JsonObject wrapper = serialized.getAsJsonObject();
        JsonElement wrapperClass = wrapper.get(CLASS);
        if (Objects.isNull(wrapperClass) || wrapperClass.isJsonNull()) {
            return Optional.empty();
        }
        try {
            Class<?> clazz = Class.forName(wrapperClass.getAsString());
            return Optional.of(this.gson.fromJson(wrapper.get(VALUE), clazz));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid JSON domain object", e);
        }
    }

    public static <D> GenericMapper<Optional<D>, JsonElement> jsonOptionalDomainMapper() {
        return INSTANCE;
    }
}

