/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.util;

import io.simplesource.kafka.serialization.util.GenericMapper;
import java.util.Map;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

public final class GenericSerde<A, S>
implements Serde<A> {
    private final Serde<S> serde;
    private final GenericMapper<A, S> mapper;
    private final Serializer<A> serializer = new Serializer<A>(){

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] serialize(String topic, A data) {
            return GenericSerde.this.serde.serializer().serialize(topic, GenericSerde.this.mapper.toGeneric(data));
        }

        public void close() {
        }
    };
    private final Deserializer<A> deserializer = new Deserializer<A>(){

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public A deserialize(String topic, byte[] data) {
            return GenericSerde.this.mapper.fromGeneric(GenericSerde.this.serde.deserializer().deserialize(topic, data));
        }

        public void close() {
        }
    };

    public static <A, S> Serde<A> of(Serde<S> serde, GenericMapper<A, S> mapper) {
        return new GenericSerde<A, S>(serde, mapper);
    }

    public static <A, S> Serde<A> of(Serde<S> serde, final Function<A, S> toGenericFn, final Function<S, A> fromGenericFn) {
        GenericMapper mapper = new GenericMapper<A, S>(){

            @Override
            public S toGeneric(A value) {
                return toGenericFn.apply(value);
            }

            @Override
            public A fromGeneric(S serialized) {
                return fromGenericFn.apply(serialized);
            }
        };
        return new GenericSerde<A, S>(serde, mapper);
    }

    private GenericSerde(Serde<S> serde, GenericMapper<A, S> mapper) {
        this.serde = serde;
        this.mapper = mapper;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.serde.configure(configs, isKey);
    }

    public void close() {
        this.serde.close();
    }

    public Serializer<A> serializer() {
        return this.serializer;
    }

    public Deserializer<A> deserializer() {
        return this.deserializer;
    }
}

