/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro.mappers;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.avro.generic.GenericRecord;

public class DomainMapperRegistry {
    private final Map<RegisterKey, RegisterMapper> mappers = Maps.newHashMap();

    public <D, A extends GenericRecord> Optional<RegisterMapper<D, A>> mapperFor(Class clazz) {
        return this.mappers.entrySet().stream().filter(this.byClass(Objects.requireNonNull(clazz))).map(Map.Entry::getValue).findAny();
    }

    public <D, A extends GenericRecord> RegisterMapper<D, A> register(Class<?> domainClazz, Class<?> avroClazz, Function<D, A> fromDomain, Function<A, D> toDomain) {
        RegisterMapper<D, A> registerMapper = new RegisterMapper<D, A>(Objects.requireNonNull(fromDomain), Objects.requireNonNull(toDomain));
        this.mappers.put(new RegisterKey(Objects.requireNonNull(domainClazz), Objects.requireNonNull(avroClazz)), registerMapper);
        return registerMapper;
    }

    private Predicate<Map.Entry<RegisterKey, RegisterMapper>> byClass(Class clazz) {
        return e -> ((RegisterKey)e.getKey()).domainClass().equals(clazz) || ((RegisterKey)e.getKey()).serializedClass().equals(clazz);
    }

    static final class RegisterMapper<D, A> {
        private final Function<D, A> fromDomainFunc;
        private final Function<A, D> toDomainFunc;

        public RegisterMapper(Function<D, A> fromDomainFunc, Function<A, D> toDomainFunc) {
            this.fromDomainFunc = fromDomainFunc;
            this.toDomainFunc = toDomainFunc;
        }

        public Function<D, A> fromDomainFunc() {
            return this.fromDomainFunc;
        }

        public Function<A, D> toDomainFunc() {
            return this.toDomainFunc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisterMapper)) {
                return false;
            }
            RegisterMapper other = (RegisterMapper)o;
            Function<D, A> this$fromDomainFunc = this.fromDomainFunc();
            Function<D, A> other$fromDomainFunc = other.fromDomainFunc();
            if (this$fromDomainFunc == null ? other$fromDomainFunc != null : !this$fromDomainFunc.equals(other$fromDomainFunc)) {
                return false;
            }
            Function<A, D> this$toDomainFunc = this.toDomainFunc();
            Function<A, D> other$toDomainFunc = other.toDomainFunc();
            return !(this$toDomainFunc == null ? other$toDomainFunc != null : !this$toDomainFunc.equals(other$toDomainFunc));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<D, A> $fromDomainFunc = this.fromDomainFunc();
            result = result * 59 + ($fromDomainFunc == null ? 43 : $fromDomainFunc.hashCode());
            Function<A, D> $toDomainFunc = this.toDomainFunc();
            result = result * 59 + ($toDomainFunc == null ? 43 : $toDomainFunc.hashCode());
            return result;
        }

        public String toString() {
            return "DomainMapperRegistry.RegisterMapper(fromDomainFunc=" + this.fromDomainFunc() + ", toDomainFunc=" + this.toDomainFunc() + ")";
        }
    }

    private final class RegisterKey {
        private final Class<?> domainClass;
        private final Class<?> serializedClass;

        public RegisterKey(Class<?> domainClass, Class<?> serializedClass) {
            this.domainClass = domainClass;
            this.serializedClass = serializedClass;
        }

        public Class<?> domainClass() {
            return this.domainClass;
        }

        public Class<?> serializedClass() {
            return this.serializedClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisterKey)) {
                return false;
            }
            RegisterKey other = (RegisterKey)o;
            Class<?> this$domainClass = this.domainClass();
            Class<?> other$domainClass = other.domainClass();
            if (this$domainClass == null ? other$domainClass != null : !this$domainClass.equals(other$domainClass)) {
                return false;
            }
            Class<?> this$serializedClass = this.serializedClass();
            Class<?> other$serializedClass = other.serializedClass();
            return !(this$serializedClass == null ? other$serializedClass != null : !this$serializedClass.equals(other$serializedClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $domainClass = this.domainClass();
            result = result * 59 + ($domainClass == null ? 43 : $domainClass.hashCode());
            Class<?> $serializedClass = this.serializedClass();
            result = result * 59 + ($serializedClass == null ? 43 : $serializedClass.hashCode());
            return result;
        }

        public String toString() {
            return "DomainMapperRegistry.RegisterKey(domainClass=" + this.domainClass() + ", serializedClass=" + this.serializedClass() + ")";
        }
    }
}

