/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.client;

import io.split.api.SplitApiClientConfig;
import io.split.api.client.exceptions.SplitException;
import io.split.api.client.exceptions.SplitJsonException;
import io.split.api.client.exceptions.SplitRequestException;
import io.split.api.client.exceptions.SplitResourceNotFoundException;
import io.split.api.client.exceptions.SplitServerErrorException;
import io.split.api.client.interceptors.AddSplitHeadersFilter;
import io.split.api.client.utils.EncodingUtil;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import split.org.apache.http.client.config.RequestConfig;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpDelete;
import split.org.apache.http.client.methods.HttpGet;
import split.org.apache.http.client.methods.HttpPatch;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.client.methods.HttpPut;
import split.org.apache.http.client.methods.HttpRequestBase;
import split.org.apache.http.config.Registry;
import split.org.apache.http.config.RegistryBuilder;
import split.org.apache.http.conn.socket.ConnectionSocketFactory;
import split.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import split.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import split.org.apache.http.conn.ssl.SSLContexts;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.impl.client.HttpClients;
import split.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import split.org.apache.http.util.EntityUtils;

public class HttpClient {
    private final CloseableHttpClient _client;
    private final URI _rootTarget;

    public HttpClient(String apiToken, SplitApiClientConfig config) throws SplitException {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContexts.custom().useTLS().build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create support for secure connection.");
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.1", "TLSv1.2"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)sslsf)).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.connectionTimeout()).setSocketTimeout(config.readTimeout()).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        this._client = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).setSSLSocketFactory(sslsf).addInterceptorLast(AddSplitHeadersFilter.instance(apiToken)).build();
        this._rootTarget = URI.create(config.endpoint());
    }

    public String get(String path, String ... arguments) throws SplitRequestException {
        HttpGet request = new HttpGet(this.buildURI(path, arguments));
        return this.executeRequest(request);
    }

    public String delete(String path, String ... arguments) throws SplitRequestException {
        HttpDelete request = new HttpDelete(this.buildURI(path, arguments));
        return this.executeRequest(request);
    }

    public String post(Object entity, String path, String ... arguments) throws SplitException {
        HttpPost request = new HttpPost(this.buildURI(path, arguments));
        request.setEntity(HttpClient.toJsonEntity(entity));
        return this.executeRequest(request);
    }

    public String put(Object entity, String path, String ... arguments) throws SplitException {
        HttpPut request = new HttpPut(this.buildURI(path, arguments));
        request.setEntity(HttpClient.toJsonEntity(entity));
        return this.executeRequest(request);
    }

    public String patch(Object entity, String path, String ... arguments) throws SplitException {
        HttpPatch request = new HttpPatch(this.buildURI(path, arguments));
        request.setEntity(HttpClient.toJsonEntity(entity));
        return this.executeRequest(request);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeRequest(HttpRequestBase request) throws SplitRequestException {
        String message2222222;
        CloseableHttpResponse response = null;
        try {
            response = this._client.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String message2222222 = String.format("Error Executing Request: message=%s method=%s path=%s status=%d", EntityUtils.toString(response.getEntity()), request.getMethod(), request.getURI().getPath(), statusCode);
                switch (statusCode) {
                    case 404: {
                        throw new SplitResourceNotFoundException(message2222222);
                    }
                    case 500: {
                        throw new SplitServerErrorException(message2222222);
                    }
                }
                throw new SplitRequestException(message2222222);
            }
            message2222222 = EntityUtils.toString(response.getEntity());
        }
        catch (SplitRequestException e) {
            try {
                throw e;
                catch (Throwable t) {
                    String message3 = String.format("Error Executing Request: method=%s path=%s", request.getMethod(), request.getURI().getPath());
                    throw new SplitRequestException(message3, t);
                }
            }
            catch (Throwable throwable) {
                HttpClient.forceClose(response);
                throw throwable;
            }
        }
        HttpClient.forceClose(response);
        return message2222222;
    }

    private URI buildURI(String pathPattern, String ... arguments) {
        String url = HttpClient.concatenateURL(this._rootTarget.toString(), String.format(pathPattern, arguments));
        return url != null ? URI.create(url) : null;
    }

    public static String concatenateURL(String ... urls) {
        if (urls.length == 0) {
            return null;
        }
        if (urls.length == 1) {
            return HttpClient.stripBackslash(urls[0]);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(HttpClient.stripBackslash(urls[0]));
        for (int i = 1; i < urls.length; ++i) {
            builder.append("/");
            builder.append(HttpClient.stripBackslash(urls[i], true));
        }
        return builder.toString();
    }

    private static String stripBackslash(String url) {
        return HttpClient.stripBackslash(url, false);
    }

    private static String stripBackslash(String url, boolean stripStarting) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (stripStarting && url.startsWith("/")) {
            url = url.substring(1, url.length());
        }
        return url;
    }

    private static StringEntity toJsonEntity(Object obj) throws SplitJsonException {
        String json = EncodingUtil.encode(obj);
        StringEntity entity = new StringEntity(json, "UTF-8");
        entity.setContentType("application/json");
        return entity;
    }

    private static void forceClose(CloseableHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

