/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.client.interceptors;

import io.split.api.client.exceptions.SplitRequestException;
import java.io.IOException;
import split.org.apache.http.HttpException;
import split.org.apache.http.HttpRequest;
import split.org.apache.http.HttpRequestInterceptor;
import split.org.apache.http.protocol.HttpContext;

public class AddSplitHeadersFilter
implements HttpRequestInterceptor {
    private final String _apiTokenBearer;

    public static AddSplitHeadersFilter instance(String apiToken) throws SplitRequestException {
        return new AddSplitHeadersFilter(apiToken);
    }

    private AddSplitHeadersFilter(String apiToken) {
        this._apiTokenBearer = "Bearer " + apiToken;
    }

    @Override
    public void process(HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        request.addHeader("Authorization", this._apiTokenBearer);
    }
}

