/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import io.codigo.dtos.AutoValue_Matcher;
import io.codigo.dtos.MatcherType;
import io.codigo.dtos.UserDefinedSegmentMatcherData;
import io.codigo.dtos.WhitelistMatcherData;
import javax.annotation.Nullable;

@JsonDeserialize(builder=AutoValue_Matcher.Builder.class)
public abstract class Matcher {
    public static Builder builder() {
        return new AutoValue_Matcher.Builder().negate(false).userDefinedSegmentMatcherData(null).whitelistMatcherData(null);
    }

    Matcher() {
    }

    @JsonProperty
    public abstract MatcherType matcherType();

    @JsonProperty
    public abstract boolean negate();

    @JsonProperty
    @Nullable
    public abstract UserDefinedSegmentMatcherData userDefinedSegmentMatcherData();

    @JsonProperty
    @Nullable
    public abstract WhitelistMatcherData whitelistMatcherData();

    public final String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("user is in ");
        if (this.whitelistMatcherData() != null) {
            bldr.append("[");
            int count = 0;
            for (String item : this.whitelistMatcherData().whitelist()) {
                if (count != 0) {
                    bldr.append(", ");
                }
                bldr.append(item);
                ++count;
            }
            bldr.append("] ");
            return bldr.toString();
        }
        if (this.userDefinedSegmentMatcherData() != null) {
            bldr.append("segment ");
            bldr.append(this.userDefinedSegmentMatcherData().segmentName());
            bldr.append(' ');
            return bldr.toString();
        }
        bldr.append("segment all ");
        return bldr.toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        public abstract Builder negate(boolean var1);

        public abstract Builder matcherType(MatcherType var1);

        public abstract MatcherType matcherType();

        public abstract Builder userDefinedSegmentMatcherData(UserDefinedSegmentMatcherData var1);

        public abstract UserDefinedSegmentMatcherData userDefinedSegmentMatcherData();

        public abstract Builder whitelistMatcherData(WhitelistMatcherData var1);

        public abstract WhitelistMatcherData whitelistMatcherData();

        abstract Matcher autobuild();

        public final Matcher build() {
            Matcher matcher = this.autobuild();
            switch (matcher.matcherType()) {
                case ALL_KEYS: {
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST BE null");
                    Preconditions.checkArgument(matcher.whitelistMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST BE null");
                    break;
                }
                case IN_SEGMENT: {
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() != null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST NOT BE null");
                    Preconditions.checkArgument(matcher.whitelistMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST BE null");
                    break;
                }
                case WHITELIST: {
                    Preconditions.checkArgument(matcher.whitelistMatcherData() != null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.whitelistMatcherData() MUST NOT BE null");
                    Preconditions.checkArgument(matcher.userDefinedSegmentMatcherData() == null, "MatcherType is " + (Object)((Object)matcher.matcherType()) + ". matcher.userDefinedSegmentMatcherData() MUST BE null");
                }
            }
            return matcher;
        }
    }
}

