/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.AutoValue_SegmentChange;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

@JsonDeserialize(builder=AutoValue_SegmentChange.Builder.class)
public abstract class SegmentChange {
    public static SegmentChange noChanges(String segmentName, long since) {
        return new AutoValue_SegmentChange.Builder().name(segmentName).added(Collections.emptyList()).removed(Collections.emptyList()).since(since).till(since).build();
    }

    public static Builder builder() {
        return new AutoValue_SegmentChange.Builder().added(Collections.emptyList()).removed(Collections.emptyList());
    }

    SegmentChange() {
    }

    @Nullable
    public abstract String id();

    @JsonProperty
    public abstract String name();

    @JsonProperty
    public abstract ImmutableList<String> added();

    @JsonProperty
    public abstract ImmutableList<String> removed();

    @JsonProperty
    public abstract long since();

    @JsonProperty
    public abstract long till();

    @JsonPOJOBuilder(withPrefix="")
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder added(List<String> var1);

        public abstract Builder removed(List<String> var1);

        public abstract Builder since(long var1);

        public abstract Builder till(long var1);

        abstract SegmentChange autobuild();

        public final SegmentChange build() {
            SegmentChange result = this.autobuild();
            if (result.since() >= 0L) {
                Preconditions.checkArgument(result.till() >= result.since(), "SegmentChange.till() MUST BE greater than or equal to SegmentChange.since()");
            }
            if (result.till() == result.since() && result.till() >= 0L) {
                Preconditions.checkArgument(result.added().isEmpty() && result.removed().isEmpty(), "When SegmentChange.till() == SegmentChange.since(), then SegmentChange.added() and SegmentChange.removed() MUST both be empty. They were not: " + result);
            }
            if (result.till() < 0L) {
                Preconditions.checkArgument(result.added().isEmpty() && result.removed().isEmpty(), "When SegmentChange.till() is less than zero, then SegmentChange should be empty. It was not: " + result);
            }
            return result;
        }
    }
}

