/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.AddSplitHeadersFilter;
import io.split.client.CachedTreatmentLogRemovalListener;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.LocalhostSplitClientBuilder;
import io.split.client.ObjectMapperProvider;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.TheseFeaturesAreOnSplitClient;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitParser;
import io.split.engine.impressions.CachedTreatmentLog;
import io.split.engine.segments.RefreshableSegmentFetcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;

public class SplitClientBuilder {
    private static Random RANDOM = new Random();
    private static AtomicReference<SplitClient> _client = new AtomicReference();
    private static Object _lock = new Object();

    public static SplitClient build(String apiToken) throws IOException {
        return SplitClientBuilder.build(apiToken, SplitClientConfig.builder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplitClient build(String apiToken, SplitClientConfig config) throws IOException {
        if (_client.get() != null) {
            return _client.get();
        }
        Object object = _lock;
        synchronized (object) {
            if (_client.get() != null) {
                return _client.get();
            }
            if ("localhost".equals(apiToken)) {
                TheseFeaturesAreOnSplitClient splitClient = LocalhostSplitClientBuilder.build();
                _client.set(splitClient);
                return splitClient;
            }
            Client client = ClientBuilder.newClient((Configuration)((Object)((ClientConfig)new ClientConfig().property("jersey.config.client.connectTimeout", config.connectionTimeoutInMs()).property("jersey.config.client.readTimeout", config.readTimeoutInMs()).register(AddSplitHeadersFilter.instance(apiToken)).register((Class)ObjectMapperProvider.class)).register((Class)JacksonFeature.class)));
            WebTarget rootTarget = client.target(config.endpoint());
            HttpMetrics httpMetrics = HttpMetrics.create(rootTarget);
            FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
            HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(rootTarget, uncachedFireAndForget);
            RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitClientBuilder.findPollingPeriod(RANDOM, config.pollForSegmentChangesEveryNSeconds()));
            SplitParser splitParser = new SplitParser(segmentFetcher);
            HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(rootTarget, uncachedFireAndForget);
            RefreshableSplitFetcherProvider experimentFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitClientBuilder.findPollingPeriod(RANDOM, config.pollForFeatureChangesEveryNSeconds()));
            CachedTreatmentLog treatmentLog = CachedTreatmentLog.instance(config.treatmentLogCacheExpireNSecondsAfterWrite(), 1000, CachedTreatmentLogRemovalListener.create(rootTarget));
            CachedMetrics cachedMetrics = new CachedMetrics(httpMetrics, 100);
            FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
            SplitClientImpl splitClient = new SplitClientImpl(experimentFetcherProvider.getFetcher(), treatmentLog, cachedFireAndForgetMetrics);
            _client.set(splitClient);
            return splitClient;
        }
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    public static void main(String ... args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: CodigoBuilder <api_token>");
            System.exit(1);
            return;
        }
        SplitClientConfig config = SplitClientConfig.builder().endpoint("http://localhost:8080/sdk/api").build();
        SplitClient client = SplitClientBuilder.build(args[0], config);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            while (line != null) {
                String[] userIdAndSplit;
                if ("exit".equals(line)) {
                    System.exit(0);
                }
                if ((userIdAndSplit = line.split(" ")).length != 2) {
                    System.out.println("Could not understand command");
                } else {
                    boolean isOn = client.isOn("User", userIdAndSplit[0], userIdAndSplit[1]);
                    System.out.println(isOn ? "on" : "off");
                }
                line = reader.readLine();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

