/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.split.api.CounterDTO;
import io.split.api.GaugeDTO;
import io.split.api.LatencyDTO;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.metrics.Metrics;
import java.util.List;
import java.util.Map;

public class CachedMetrics
implements Metrics {
    private final HttpMetrics _httpMetrics;
    private final Map<String, List<Long>> _latencyMap;
    private final Map<String, SumAndCount> _countMap;
    private final Map<String, ValueAndCount> _gaugeMap;
    private final Object _latencyLock = new Object();
    private final Object _counterLock = new Object();
    private final Object _gaugeLock = new Object();
    private final int _queueForTheseManyCalls;

    public CachedMetrics(HttpMetrics httpMetrics, int queueForTheseManyCalls) {
        this._httpMetrics = httpMetrics;
        this._latencyMap = Maps.newHashMap();
        this._countMap = Maps.newHashMap();
        this._gaugeMap = Maps.newHashMap();
        Preconditions.checkArgument(queueForTheseManyCalls > 0, "queue for cache should be greater than zero");
        this._queueForTheseManyCalls = queueForTheseManyCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void count(String counter, long delta) {
        if (delta <= 0L) {
            return;
        }
        if (counter == null || counter.trim().isEmpty()) {
            return;
        }
        Object object = this._counterLock;
        synchronized (object) {
            SumAndCount ifPresent = this._countMap.get(counter);
            if (ifPresent == null) {
                ifPresent = new SumAndCount();
                this._countMap.put(counter, ifPresent);
            }
            ifPresent.addDelta(delta);
            if (ifPresent._count >= this._queueForTheseManyCalls) {
                CounterDTO dto = CounterDTO.builder().name(counter).delta(ifPresent._sum).build();
                ifPresent.clear();
                this._httpMetrics.count(dto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gauge(String gauge, double value) {
        if (gauge == null || gauge.trim().isEmpty()) {
            return;
        }
        Object object = this._gaugeLock;
        synchronized (object) {
            ValueAndCount ifPresent = this._gaugeMap.get(gauge);
            if (ifPresent == null) {
                ifPresent = new ValueAndCount();
                this._gaugeMap.put(gauge, ifPresent);
            }
            ifPresent.setValue(value);
            if (ifPresent._count >= this._queueForTheseManyCalls) {
                GaugeDTO dto = GaugeDTO.builder().name(gauge).value(ifPresent._value).build();
                ifPresent.clear();
                this._httpMetrics.gauge(dto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(String operation, long timeInMs) {
        if (operation == null || operation.trim().isEmpty() || timeInMs < 0L) {
            return;
        }
        Object object = this._latencyLock;
        synchronized (object) {
            List<Object> list;
            if (!this._latencyMap.containsKey(operation)) {
                list = Lists.newArrayListWithExpectedSize(this._queueForTheseManyCalls);
                this._latencyMap.put(operation, list);
            }
            list = this._latencyMap.get(operation);
            list.add(timeInMs);
            if (list.size() >= this._queueForTheseManyCalls) {
                LatencyDTO dto = LatencyDTO.builder().name(operation).latencies(Lists.newArrayList(list)).build();
                list.clear();
                this._httpMetrics.time(dto);
            }
        }
    }

    private static final class ValueAndCount {
        private int _count = 0;
        private double _value = 0.0;

        private ValueAndCount() {
        }

        public void setValue(double value) {
            ++this._count;
            this._value = value;
        }

        public void clear() {
            this._count = 0;
            this._value = 0.0;
        }
    }

    private static final class SumAndCount {
        private int _count = 0;
        private long _sum = 0L;

        private SumAndCount() {
        }

        public void addDelta(long delta) {
            ++this._count;
            this._sum += delta;
        }

        public void clear() {
            this._count = 0;
            this._sum = 0L;
        }
    }
}

