/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.codigo.dtos.Partition;
import io.split.engine.matchers.Matcher;
import java.util.List;

public final class ParsedCondition {
    private final Matcher _matcher;
    private final List<Partition> _partitions;

    public ParsedCondition(Matcher matcher, List<Partition> partitions) {
        this._matcher = matcher;
        this._partitions = partitions;
    }

    public Matcher matcher() {
        return this._matcher;
    }

    public List<Partition> partitions() {
        return this._partitions;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._matcher.hashCode();
        result = 31 * result + this._partitions.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParsedCondition)) {
            return false;
        }
        ParsedCondition other = (ParsedCondition)obj;
        return this._matcher.equals(other._matcher) && this._partitions.equals(other._partitions);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("if key is ");
        bldr.append(this._matcher);
        bldr.append(" then split ");
        boolean first = true;
        for (Partition partition : this._partitions) {
            if (!first) {
                bldr.append(',');
            }
            bldr.append(partition.size());
            bldr.append(':');
            bldr.append(partition.treatment());
            first = false;
        }
        return bldr.toString();
    }
}

