/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.codigo.dtos.KeyImpressionDTO;
import javax.annotation.Nullable;

final class AutoValue_KeyImpressionDTO
extends KeyImpressionDTO {
    private final String keyId;
    private final String keyName;
    private final String treatment;
    private final long time;

    private AutoValue_KeyImpressionDTO(@Nullable String keyId, @Nullable String keyName, String treatment, long time) {
        this.keyId = keyId;
        this.keyName = keyName;
        if (treatment == null) {
            throw new NullPointerException("Null treatment");
        }
        this.treatment = treatment;
        this.time = time;
    }

    @Override
    @Nullable
    @JsonProperty
    public String keyId() {
        return this.keyId;
    }

    @Override
    @Nullable
    @JsonProperty
    public String keyName() {
        return this.keyName;
    }

    @Override
    @JsonProperty
    public String treatment() {
        return this.treatment;
    }

    @Override
    @JsonProperty
    public long time() {
        return this.time;
    }

    public String toString() {
        return "KeyImpressionDTO{keyId=" + this.keyId + ", " + "keyName=" + this.keyName + ", " + "treatment=" + this.treatment + ", " + "time=" + this.time + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeyImpressionDTO) {
            KeyImpressionDTO that = (KeyImpressionDTO)o;
            return (this.keyId == null ? that.keyId() == null : this.keyId.equals(that.keyId())) && (this.keyName == null ? that.keyName() == null : this.keyName.equals(that.keyName())) && this.treatment.equals(that.treatment()) && this.time == that.time();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.keyId == null ? 0 : this.keyId.hashCode();
        h *= 1000003;
        h ^= this.keyName == null ? 0 : this.keyName.hashCode();
        h *= 1000003;
        h ^= this.treatment.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.time >>> 32 ^ this.time));
        return h;
    }

    static final class Builder
    extends KeyImpressionDTO.Builder {
        private String keyId;
        private String keyName;
        private String treatment;
        private Long time;

        Builder() {
        }

        Builder(KeyImpressionDTO source) {
            this.keyId = source.keyId();
            this.keyName = source.keyName();
            this.treatment = source.treatment();
            this.time = source.time();
        }

        @Override
        public KeyImpressionDTO.Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public KeyImpressionDTO.Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        @Override
        public KeyImpressionDTO.Builder treatment(String treatment) {
            this.treatment = treatment;
            return this;
        }

        @Override
        public KeyImpressionDTO.Builder time(long time) {
            this.time = time;
            return this;
        }

        @Override
        public KeyImpressionDTO build() {
            String missing = "";
            if (this.treatment == null) {
                missing = missing + " treatment";
            }
            if (this.time == null) {
                missing = missing + " time";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_KeyImpressionDTO(this.keyId, this.keyName, this.treatment, this.time);
        }
    }
}

