/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.SegmentChange;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_SegmentChange
extends SegmentChange {
    private final String id;
    private final String name;
    private final ImmutableList<String> added;
    private final ImmutableList<String> removed;
    private final long since;
    private final long till;

    private AutoValue_SegmentChange(@Nullable String id, String name, ImmutableList<String> added, ImmutableList<String> removed, long since, long till) {
        this.id = id;
        if (name == null) {
            throw new NullPointerException("Null name");
        }
        this.name = name;
        if (added == null) {
            throw new NullPointerException("Null added");
        }
        this.added = added;
        if (removed == null) {
            throw new NullPointerException("Null removed");
        }
        this.removed = removed;
        this.since = since;
        this.till = till;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    public ImmutableList<String> added() {
        return this.added;
    }

    @Override
    @JsonProperty
    public ImmutableList<String> removed() {
        return this.removed;
    }

    @Override
    @JsonProperty
    public long since() {
        return this.since;
    }

    @Override
    @JsonProperty
    public long till() {
        return this.till;
    }

    public String toString() {
        return "SegmentChange{id=" + this.id + ", " + "name=" + this.name + ", " + "added=" + this.added + ", " + "removed=" + this.removed + ", " + "since=" + this.since + ", " + "till=" + this.till + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SegmentChange) {
            SegmentChange that = (SegmentChange)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.name.equals(that.name()) && this.added.equals(that.added()) && this.removed.equals(that.removed()) && this.since == that.since() && this.till == that.till();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.added.hashCode();
        h *= 1000003;
        h ^= this.removed.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.since >>> 32 ^ this.since));
        h *= 1000003;
        h = (int)((long)h ^ (this.till >>> 32 ^ this.till));
        return h;
    }

    static final class Builder
    extends SegmentChange.Builder {
        private String id;
        private String name;
        private ImmutableList<String> added;
        private ImmutableList<String> removed;
        private Long since;
        private Long till;

        Builder() {
        }

        Builder(SegmentChange source) {
            this.id = source.id();
            this.name = source.name();
            this.added = source.added();
            this.removed = source.removed();
            this.since = source.since();
            this.till = source.till();
        }

        @Override
        public SegmentChange.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public SegmentChange.Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SegmentChange.Builder added(List<String> added) {
            this.added = ImmutableList.copyOf(added);
            return this;
        }

        @Override
        public SegmentChange.Builder removed(List<String> removed) {
            this.removed = ImmutableList.copyOf(removed);
            return this;
        }

        @Override
        public SegmentChange.Builder since(long since) {
            this.since = since;
            return this;
        }

        @Override
        public SegmentChange.Builder till(long till) {
            this.till = till;
            return this;
        }

        @Override
        public SegmentChange autobuild() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.added == null) {
                missing = missing + " added";
            }
            if (this.removed == null) {
                missing = missing + " removed";
            }
            if (this.since == null) {
                missing = missing + " since";
            }
            if (this.till == null) {
                missing = missing + " till";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SegmentChange(this.id, this.name, this.added, this.removed, this.since, this.till);
        }
    }
}

