/*
 * Decompiled with CFR 0.152.
 */
package io.codigo.dtos;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.codigo.dtos.Split;
import io.codigo.dtos.SplitChange;
import java.util.List;

final class AutoValue_SplitChange
extends SplitChange {
    private final ImmutableList<Split> splits;
    private final long since;
    private final long till;

    private AutoValue_SplitChange(ImmutableList<Split> splits, long since, long till) {
        if (splits == null) {
            throw new NullPointerException("Null splits");
        }
        this.splits = splits;
        this.since = since;
        this.till = till;
    }

    @Override
    @JsonProperty
    public ImmutableList<Split> splits() {
        return this.splits;
    }

    @Override
    @JsonProperty
    public long since() {
        return this.since;
    }

    @Override
    @JsonProperty
    public long till() {
        return this.till;
    }

    public String toString() {
        return "SplitChange{splits=" + this.splits + ", " + "since=" + this.since + ", " + "till=" + this.till + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SplitChange) {
            SplitChange that = (SplitChange)o;
            return this.splits.equals(that.splits()) && this.since == that.since() && this.till == that.till();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.splits.hashCode();
        h *= 1000003;
        h = (int)((long)h ^ (this.since >>> 32 ^ this.since));
        h *= 1000003;
        h = (int)((long)h ^ (this.till >>> 32 ^ this.till));
        return h;
    }

    static final class Builder
    extends SplitChange.Builder {
        private ImmutableList<Split> splits;
        private Long since;
        private Long till;

        Builder() {
        }

        Builder(SplitChange source) {
            this.splits = source.splits();
            this.since = source.since();
            this.till = source.till();
        }

        @Override
        public SplitChange.Builder splits(List<Split> splits) {
            this.splits = ImmutableList.copyOf(splits);
            return this;
        }

        @Override
        public SplitChange.Builder since(long since) {
            this.since = since;
            return this;
        }

        @Override
        public SplitChange.Builder till(long till) {
            this.till = till;
            return this;
        }

        @Override
        public SplitChange autobuild() {
            String missing = "";
            if (this.splits == null) {
                missing = missing + " splits";
            }
            if (this.since == null) {
                missing = missing + " since";
            }
            if (this.till == null) {
                missing = missing + " till";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SplitChange(this.splits, this.since, this.till);
        }
    }
}

