/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.SplitClient;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.impressions.TreatmentLog;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFetcher _splitFetcher;
    private final TreatmentLog _treatmentLog;
    private final Metrics _metrics;

    public SplitClientImpl(SplitFetcher splitFetcher, TreatmentLog treatmentLog, Metrics metrics) {
        this._splitFetcher = splitFetcher;
        this._treatmentLog = treatmentLog;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._splitFetcher);
        Preconditions.checkNotNull(this._treatmentLog);
    }

    @Override
    public boolean isTreatment(String id, String feature, String treatment) {
        if (treatment == null) {
            return false;
        }
        boolean isTreatment = false;
        try {
            long start = System.currentTimeMillis();
            isTreatment = this.getTreatment(id, feature, "").equals(treatment);
            return isTreatment;
        }
        catch (Throwable t) {
            _log.error("MUST NOT throw this exception", t);
            return isTreatment;
        }
    }

    @Override
    public String getTreatment(String id, String feature, String defaultTreatment) {
        if (id == null) {
            _log.warn("id was null for feature: " + feature);
            return defaultTreatment;
        }
        if (feature == null) {
            _log.warn("feature was null for id: " + id);
            return defaultTreatment;
        }
        if (defaultTreatment == null) {
            _log.warn("default treatment was null for id: " + id);
            return defaultTreatment;
        }
        long start = System.currentTimeMillis();
        String result = null;
        try {
            result = this.getTreatmentWithoutExceptionHandling(id, feature, defaultTreatment);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
        result = result == null ? defaultTreatment : result;
        try {
            this._treatmentLog.log(id, feature, result, System.currentTimeMillis());
            this._metrics.time("sdk.getTreatment", System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
        return result;
    }

    private String getTreatmentWithoutExceptionHandling(String id, String feature, String defaultTreatment) {
        ParsedSplit experiment = this._splitFetcher.fetch(feature);
        if (experiment == null) {
            return defaultTreatment;
        }
        return this.getTreatment(id, experiment, defaultTreatment);
    }

    private String getTreatment(String userId, ParsedSplit experiment, String defaultTreatment) {
        for (ParsedCondition parsedCondition : experiment.matcherAndSplits()) {
            if (!parsedCondition.matcher().match(userId)) continue;
            String result = Splitter.getTreatment(userId, experiment.seed(), parsedCondition.partitions());
            if (result == null) {
                return defaultTreatment;
            }
            return result;
        }
        return defaultTreatment;
    }
}

