/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import io.split.api.CounterDTO;
import io.split.api.GaugeDTO;
import io.split.api.LatencyDTO;
import io.split.client.metrics.BinarySearchLatencyTracker;
import io.split.client.metrics.HttpMetrics;
import io.split.client.metrics.ILatencyTracker;
import io.split.engine.metrics.Metrics;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CachedMetrics
implements Metrics {
    private final HttpMetrics _httpMetrics;
    private final Map<String, ILatencyTracker> _latencyMap;
    private final Map<String, SumAndCount> _countMap;
    private final Map<String, ValueAndCount> _gaugeMap;
    private final Object _latencyLock = new Object();
    private long _latencyLastUpdateTimeMillis = System.currentTimeMillis();
    private final Object _counterLock = new Object();
    private long _counterLastUpdateTimeMillis = System.currentTimeMillis();
    private final Object _gaugeLock = new Object();
    private long _gaugeLastUpdateTimeMillis = System.currentTimeMillis();
    private long _refreshPeriodInMillis;
    private final int _queueForTheseManyCalls;

    public CachedMetrics(HttpMetrics httpMetrics, int queueForTheseManyCalls) {
        this(httpMetrics, queueForTheseManyCalls, TimeUnit.MINUTES.toMillis(5L));
    }

    public CachedMetrics(HttpMetrics httpMetrics, int queueForTheseManyCalls, long refreshPeriodInMillis) {
        this._httpMetrics = httpMetrics;
        this._latencyMap = Maps.newHashMap();
        this._countMap = Maps.newHashMap();
        this._gaugeMap = Maps.newHashMap();
        Preconditions.checkArgument(queueForTheseManyCalls > 0, "queue for cache should be greater than zero");
        this._queueForTheseManyCalls = queueForTheseManyCalls;
        this._refreshPeriodInMillis = refreshPeriodInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void count(String counter, long delta) {
        if (delta <= 0L) {
            return;
        }
        if (counter == null || counter.trim().isEmpty()) {
            return;
        }
        Object object = this._counterLock;
        synchronized (object) {
            SumAndCount ifPresent = this._countMap.get(counter);
            if (ifPresent == null) {
                ifPresent = new SumAndCount();
                this._countMap.put(counter, ifPresent);
            }
            ifPresent.addDelta(delta);
            if (ifPresent._count >= this._queueForTheseManyCalls || this.hasTimeElapsed(this._counterLastUpdateTimeMillis)) {
                CounterDTO dto = CounterDTO.builder().name(counter).delta(ifPresent._sum).build();
                ifPresent.clear();
                this._counterLastUpdateTimeMillis = System.currentTimeMillis();
                this._httpMetrics.count(dto);
            }
        }
    }

    private boolean hasTimeElapsed(long lastRefreshTime) {
        return System.currentTimeMillis() - lastRefreshTime > this._refreshPeriodInMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gauge(String gauge, double value) {
        if (gauge == null || gauge.trim().isEmpty()) {
            return;
        }
        Object object = this._gaugeLock;
        synchronized (object) {
            ValueAndCount ifPresent = this._gaugeMap.get(gauge);
            if (ifPresent == null) {
                ifPresent = new ValueAndCount();
                this._gaugeMap.put(gauge, ifPresent);
            }
            ifPresent.setValue(value);
            if (ifPresent._count >= this._queueForTheseManyCalls || this.hasTimeElapsed(this._gaugeLastUpdateTimeMillis)) {
                GaugeDTO dto = GaugeDTO.builder().name(gauge).value(ifPresent._value).build();
                ifPresent.clear();
                this._gaugeLastUpdateTimeMillis = System.currentTimeMillis();
                this._httpMetrics.gauge(dto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void time(String operation, long timeInMs) {
        if (operation == null || operation.trim().isEmpty() || timeInMs < 0L) {
            return;
        }
        Object object = this._latencyLock;
        synchronized (object) {
            if (!this._latencyMap.containsKey(operation)) {
                BinarySearchLatencyTracker latencies = new BinarySearchLatencyTracker();
                this._latencyMap.put(operation, latencies);
            }
            ILatencyTracker tracker = this._latencyMap.get(operation);
            tracker.addLatencyMillis((int)timeInMs);
            if (this.hasTimeElapsed(this._latencyLastUpdateTimeMillis)) {
                LatencyDTO dto = LatencyDTO.builder().name(operation).latencies(Longs.asList(tracker.getLatencies())).build();
                tracker.clear();
                this._latencyLastUpdateTimeMillis = System.currentTimeMillis();
                this._httpMetrics.time(dto);
            }
        }
    }

    private static final class ValueAndCount {
        private int _count = 0;
        private double _value = 0.0;

        private ValueAndCount() {
        }

        public void setValue(double value) {
            ++this._count;
            this._value = value;
        }

        public void clear() {
            this._count = 0;
            this._value = 0.0;
        }
    }

    private static final class SumAndCount {
        private int _count = 0;
        private long _sum = 0L;

        private SumAndCount() {
        }

        public void addDelta(long delta) {
            ++this._count;
            this._sum += delta;
        }

        public void clear() {
            this._count = 0;
            this._sum = 0L;
        }
    }
}

