/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.splitter;

import io.codigo.dtos.Partition;
import java.util.List;

public class Splitter {
    public static String getTreatment(String key, int seed, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return null;
        }
        if (Splitter.hundredPercentOneTreatment(partitions)) {
            return partitions.get(0).treatment();
        }
        return Splitter.getTreatment(Splitter.bucket(Splitter.hash(key, seed)), partitions);
    }

    static int hash(String key, int seed) {
        int h = 0;
        for (int i = 0; i < key.length(); ++i) {
            h = 31 * h + key.charAt(i);
        }
        return h ^ seed;
    }

    private static String getTreatment(int bucket, List<Partition> partitions) {
        int bucketsCoveredThusFar = 0;
        for (Partition partition : partitions) {
            if ((bucketsCoveredThusFar += partition.size()) < bucket) continue;
            return partition.treatment();
        }
        return null;
    }

    static int bucket(int hash) {
        return Math.abs(hash % 100) + 1;
    }

    private static boolean hundredPercentOneTreatment(List<Partition> partitions) {
        if (partitions.size() != 1) {
            return false;
        }
        return partitions.get(0).size() == 100;
    }
}

