/*
 * Decompiled with CFR 0.152.
 */
package split.org.apache.http.protocol;

import java.io.IOException;
import split.org.apache.http.HttpException;
import split.org.apache.http.HttpResponse;
import split.org.apache.http.HttpResponseInterceptor;
import split.org.apache.http.annotation.ThreadSafe;
import split.org.apache.http.protocol.HttpContext;
import split.org.apache.http.protocol.HttpDateGenerator;
import split.org.apache.http.util.Args;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

