/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.split.client.SplitManager;
import io.split.client.api.SplitView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class LocalhostSplitManager
implements SplitManager {
    private final ImmutableMap<String, String> _featureToTreatmentMap;

    public LocalhostSplitManager(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @Override
    public List<SplitView> splits() {
        ArrayList<SplitView> result = new ArrayList<SplitView>();
        for (Map.Entry entry : this._featureToTreatmentMap.entrySet()) {
            result.add(this.toSplitView((String)entry.getKey(), (String)entry.getValue()));
        }
        return result;
    }

    @Override
    public List<String> splitNames() {
        return Lists.newArrayList((Iterable)this._featureToTreatmentMap.keySet());
    }

    @Override
    public SplitView split(String featureName) {
        if (!this._featureToTreatmentMap.containsKey((Object)featureName)) {
            return null;
        }
        return this.toSplitView(featureName, (String)this._featureToTreatmentMap.get((Object)featureName));
    }

    private SplitView toSplitView(String featureName, String treatment) {
        SplitView view = new SplitView();
        view.name = featureName;
        view.killed = false;
        view.trafficType = null;
        view.changeNumber = 0L;
        view.treatments = new ArrayList<String>();
        if (treatment != null) {
            view.treatments.add(treatment);
        }
        return view;
    }
}

