/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import com.google.common.base.Preconditions;
import io.split.engine.matchers.Matcher;
import java.util.Map;
import java.util.Objects;

public final class AttributeMatcher {
    private final String _attribute;
    private final Matcher _matcher;

    public static AttributeMatcher vanilla(Matcher matcher) {
        return new AttributeMatcher(null, matcher, false);
    }

    public AttributeMatcher(String attribute, Matcher matcher, boolean negate) {
        this._attribute = attribute;
        Preconditions.checkNotNull((Object)matcher);
        this._matcher = new NegatableMatcher(matcher, negate);
    }

    public boolean match(String key, Map<String, Object> attributes) {
        if (this._attribute == null) {
            return this._matcher.match(key);
        }
        if (attributes == null) {
            return false;
        }
        Object value = attributes.get(this._attribute);
        if (value == null) {
            return false;
        }
        return this._matcher.match(value);
    }

    public int hashCode() {
        return Objects.hash(this._attribute, this._matcher);
    }

    public String attribute() {
        return this._attribute;
    }

    public Matcher matcher() {
        return this._matcher;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeMatcher)) {
            return false;
        }
        AttributeMatcher other = (AttributeMatcher)obj;
        return Objects.equals(this._attribute, other._attribute) && this._matcher.equals(other._matcher);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("key");
        if (this._attribute != null) {
            bldr.append(".");
            bldr.append(this._attribute);
        }
        bldr.append(" is");
        bldr.append(this._matcher);
        return bldr.toString();
    }

    public static final class NegatableMatcher
    implements Matcher {
        private final boolean _negate;
        private final Matcher _delegate;

        public NegatableMatcher(Matcher matcher, boolean negate) {
            this._negate = negate;
            this._delegate = matcher;
        }

        @Override
        public boolean match(Object key) {
            boolean result = this._delegate.match(key);
            return this._negate ? !result : result;
        }

        public int hashCode() {
            return Objects.hash(this._negate, this._delegate);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NegatableMatcher)) {
                return false;
            }
            NegatableMatcher other = (NegatableMatcher)obj;
            return this._negate == other._negate && this._delegate.equals(other._delegate);
        }

        public String toString() {
            StringBuilder bldr = new StringBuilder();
            if (this._negate) {
                bldr.append(" not");
            }
            bldr.append(" ");
            bldr.append(this._delegate);
            return bldr.toString();
        }

        public Matcher delegate() {
            return this._delegate;
        }
    }
}

