/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import io.split.client.ChangeNumberExceptionWrapper;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.api.Key;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.impressions.TreatmentLog;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private final SplitFetcher _splitFetcher;
    private final TreatmentLog _treatmentLog;
    private final Metrics _metrics;
    private final SplitClientConfig _config;

    public SplitClientImpl(SplitFetcher splitFetcher, TreatmentLog treatmentLog, Metrics metrics, SplitClientConfig config) {
        this._splitFetcher = splitFetcher;
        this._treatmentLog = treatmentLog;
        this._metrics = metrics;
        this._config = config;
        Preconditions.checkNotNull((Object)this._splitFetcher);
        Preconditions.checkNotNull((Object)this._treatmentLog);
    }

    @Override
    public String getTreatment(String key, String feature) {
        return this.getTreatment(key, feature, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String feature, Map<String, Object> attributes) {
        return this.getTreatment(key, key, feature, attributes);
    }

    @Override
    public String getTreatment(Key key, String feature, Map<String, Object> attributes) {
        if (key == null) {
            _log.warn("key object was null for feature: " + feature);
            return "control";
        }
        return this.getTreatment(key.matchingKey(), key.bucketingKey(), feature, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getTreatment(String matchingKey, String bucketingKey, String feature, Map<String, Object> attributes) {
        try {
            if (matchingKey == null) {
                _log.warn("matchingKey was null for feature: " + feature);
                return "control";
            }
            if (bucketingKey == null) {
                _log.warn("bucketingKey was null for feature: " + feature);
                return "control";
            }
            if (feature == null) {
                _log.warn("feature was null for key: " + matchingKey);
                return "control";
            }
            long start = System.currentTimeMillis();
            TreatmentLabelAndChangeNumber result = null;
            try {
                result = this.getTreatmentWithoutExceptionHandling(matchingKey, bucketingKey, feature, attributes);
            }
            catch (ChangeNumberExceptionWrapper e) {
                result = new TreatmentLabelAndChangeNumber("control", "exception", e.changeNumber());
                _log.error("Exception", (Throwable)e.wrappedException());
                this.recordStats(matchingKey, bucketingKey, feature, start, result._treatment, "sdk.getTreatment", this._config.labelsEnabled() ? result._label : null, result._changeNumber);
            }
            catch (Exception e2) {
                result = new TreatmentLabelAndChangeNumber("control", "exception");
                _log.error("Exception", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        this.recordStats(matchingKey, bucketingKey, feature, start, result._treatment, "sdk.getTreatment", this._config.labelsEnabled() ? result._label : null, result._changeNumber);
                        throw throwable;
                    }
                }
                this.recordStats(matchingKey, bucketingKey, feature, start, result._treatment, "sdk.getTreatment", this._config.labelsEnabled() ? result._label : null, result._changeNumber);
            }
            this.recordStats(matchingKey, bucketingKey, feature, start, result._treatment, "sdk.getTreatment", this._config.labelsEnabled() ? result._label : null, result._changeNumber);
            return result._treatment;
        }
        catch (Exception e) {
            try {
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "control";
        }
    }

    private void recordStats(String matchingKey, String bucketingKey, String feature, long start, String result, String operation, String label, Long changeNumber) {
        try {
            this._treatmentLog.log(matchingKey, bucketingKey, feature, result, System.currentTimeMillis(), label, changeNumber);
            this._metrics.time(operation, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    private TreatmentLabelAndChangeNumber getTreatmentWithoutExceptionHandling(String matchingKey, String bucketingKey, String feature, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        ParsedSplit parsedSplit = this._splitFetcher.fetch(feature);
        if (parsedSplit == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Returning control because no split was found for: " + feature);
            }
            return new TreatmentLabelAndChangeNumber("control", "rules not found");
        }
        return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
    }

    private TreatmentLabelAndChangeNumber getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        try {
            if (parsedSplit.killed()) {
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "killed", parsedSplit.changeNumber());
            }
            for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
                if (!parsedCondition.matcher().match(matchingKey, attributes)) continue;
                String treatment = Splitter.getTreatment(bucketingKey, parsedSplit.seed(), parsedCondition.partitions());
                return new TreatmentLabelAndChangeNumber(treatment, parsedCondition.label(), parsedSplit.changeNumber());
            }
            return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), "no rule matched", parsedSplit.changeNumber());
        }
        catch (Exception e) {
            throw new ChangeNumberExceptionWrapper(e, parsedSplit.changeNumber());
        }
    }

    private static final class TreatmentLabelAndChangeNumber {
        private final String _treatment;
        private final String _label;
        private final Long _changeNumber;

        public TreatmentLabelAndChangeNumber(String treatment, String label) {
            this(treatment, label, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber) {
            this._treatment = treatment;
            this._label = label;
            this._changeNumber = changeNumber;
        }
    }
}

