/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import io.split.client.metrics.ILatencyTracker;
import java.util.Arrays;

public class BinarySearchLatencyTracker
implements ILatencyTracker {
    static final long[] BUCKETS = new long[]{1000L, 1500L, 2250L, 3375L, 5063L, 7594L, 11391L, 17086L, 25629L, 38443L, 57665L, 86498L, 129746L, 194620L, 291929L, 437894L, 656841L, 985261L, 1477892L, 2216838L, 3325257L, 4987885L, 7481828L};
    static final long MAX_LATENCY = 7481828L;
    long[] latencies = new long[BUCKETS.length];

    @Override
    public void addLatencyMillis(long millis) {
        int index;
        int n = index = this.findIndex(millis * 1000L);
        this.latencies[n] = this.latencies[n] + 1L;
    }

    @Override
    public void addLatencyMicros(long micros) {
        int index;
        int n = index = this.findIndex(micros);
        this.latencies[n] = this.latencies[n] + 1L;
    }

    @Override
    public long[] getLatencies() {
        return this.latencies;
    }

    @Override
    public long getLatency(int index) {
        return this.latencies[index];
    }

    @Override
    public void clear() {
        this.latencies = new long[BUCKETS.length];
    }

    @Override
    public long getBucketForLatencyMillis(long latency) {
        return this.latencies[this.findIndex(latency * 1000L)];
    }

    @Override
    public long getBucketForLatencyMicros(long latency) {
        return this.latencies[this.findIndex(latency)];
    }

    private int findIndex(long micros) {
        if (micros > 7481828L) {
            return BUCKETS.length - 1;
        }
        int index = Arrays.binarySearch(BUCKETS, micros);
        if (index < 0) {
            index = -(index + 1);
        }
        return index;
    }
}

