/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.split.client.SplitClient;
import io.split.client.api.Key;
import java.util.Map;

public final class LocalhostSplitClient
implements SplitClient {
    private ImmutableMap<String, String> _featureToTreatmentMap;

    public LocalhostSplitClient(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @Override
    public String getTreatment(String key, String split) {
        if (key == null || split == null) {
            return "control";
        }
        String treatment = (String)this._featureToTreatmentMap.get((Object)split);
        if (treatment == null) {
            return "control";
        }
        return treatment;
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key, split);
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key.matchingKey(), split, attributes);
    }

    void updateFeatureToTreatmentMap(Map<String, String> featureToTreatmentMap) {
        Preconditions.checkNotNull(featureToTreatmentMap, (Object)"featureToTreatmentMap must not be null");
        this._featureToTreatmentMap = ImmutableMap.copyOf(featureToTreatmentMap);
    }

    @VisibleForTesting
    ImmutableMap<String, String> featureToTreatmentMap() {
        return this._featureToTreatmentMap;
    }
}

