/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers.collections;

import io.split.engine.matchers.Matcher;
import io.split.engine.matchers.Transformers;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class PartOfSetMatcher
implements Matcher {
    private final Set<String> _compareTo = new HashSet<String>();

    public PartOfSetMatcher(Collection<String> compareTo) {
        if (compareTo == null) {
            throw new IllegalArgumentException("Null whitelist");
        }
        this._compareTo.addAll(compareTo);
    }

    @Override
    public boolean match(Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof Collection)) {
            return false;
        }
        Set<String> keyAsSet = Transformers.toSetOfStrings((Collection)key);
        if (keyAsSet.isEmpty()) {
            return false;
        }
        return this._compareTo.containsAll(keyAsSet);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("is part of ");
        bldr.append(this._compareTo);
        return bldr.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._compareTo.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartOfSetMatcher)) {
            return false;
        }
        PartOfSetMatcher other = (PartOfSetMatcher)obj;
        return this._compareTo.equals(other._compareTo);
    }
}

