/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sun.nio.file.SensitivityWatchEventModifier;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitAndKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalhostSplitFile
extends Thread {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSplitFile.class);
    private final LocalhostSplitFactory _splitFactory;
    private final File _file;
    private final WatchService _watcher;
    private final AtomicBoolean _stop;

    public LocalhostSplitFile(LocalhostSplitFactory splitFactory, String directory, String fileName) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkNotNull((Object)fileName);
        this._splitFactory = (LocalhostSplitFactory)Preconditions.checkNotNull((Object)splitFactory);
        this._file = new File(directory, fileName);
        this._watcher = FileSystems.getDefault().newWatchService();
        this._stop = new AtomicBoolean(false);
    }

    private boolean isStopped() {
        return this._stop.get();
    }

    public void stopThread() {
        this._stop.set(true);
    }

    public void registerWatcher() throws IOException {
        Path path = this._file.toPath().toAbsolutePath().getParent();
        path.register(this._watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY}, SensitivityWatchEventModifier.HIGH);
    }

    @Override
    public void run() {
        try {
            while (!this.isStopped()) {
                WatchKey key;
                try {
                    key = this._watcher.poll(250L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    this.stopThread();
                    return;
                }
                if (key == null) {
                    Thread.yield();
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    boolean valid;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path filename = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY && filename.toString().equals(this._file.getName())) {
                        Map<SplitAndKey, String> featureToSplitMap = this.readOnSplits();
                        this._splitFactory.updateFeatureToTreatmentMap(featureToSplitMap);
                        _log.info("Detected change in Local Splits file - Splits Reloaded! file={}", (Object)this._file.getPath());
                    }
                    if (valid = key.reset()) continue;
                    break;
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            _log.error("Error reading file: path={}", (Object)this._file.getPath(), (Object)e);
            this.stopThread();
        }
    }

    public Map<SplitAndKey, String> readOnSplits() throws IOException {
        HashMap onSplits = Maps.newHashMap();
        try (BufferedReader reader = new BufferedReader(new FileReader(this._file));){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    String[] feature_treatment = line.split("\\s+");
                    if (feature_treatment.length < 2 || feature_treatment.length > 3) {
                        _log.info("Ignoring line since it does not have 2 or 3 columns: " + line);
                    } else {
                        SplitAndKey splitAndKey = null;
                        splitAndKey = feature_treatment.length == 2 ? SplitAndKey.of(feature_treatment[0]) : SplitAndKey.of(feature_treatment[0], feature_treatment[2]);
                        onSplits.put(splitAndKey, feature_treatment[1]);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            _log.warn("There was no file named " + this._file.getPath() + " found. We created a split client that returns default treatments for all features for all of your users. If you wish to return a specific treatment for a feature, enter the name of that feature name and treatment name separated by whitespace in " + this._file.getPath() + "; one pair per line. Empty lines or lines starting with '#' are considered comments", (Throwable)e);
        }
        return onSplits;
    }
}

