/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.split.client.EventClient;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitFactory;
import io.split.client.api.Key;
import io.split.client.dtos.ConditionType;
import io.split.client.dtos.Event;
import io.split.client.exceptions.ChangeNumberExceptionWrapper;
import io.split.client.impressions.Impression;
import io.split.client.impressions.ImpressionListener;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.ParsedCondition;
import io.split.engine.experiments.ParsedSplit;
import io.split.engine.experiments.SplitFetcher;
import io.split.engine.metrics.Metrics;
import io.split.engine.splitter.Splitter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SplitClientImpl
implements SplitClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitClientImpl.class);
    private static final String NOT_IN_SPLIT = "not in split";
    private static final String DEFAULT_RULE = "default rule";
    private static final String DEFINITION_NOT_FOUND = "definition not found";
    private static final String EXCEPTION = "exception";
    private static final String KILLED = "killed";
    private final SplitFactory _container;
    private final SplitFetcher _splitFetcher;
    private final ImpressionListener _impressionListener;
    private final Metrics _metrics;
    private final SplitClientConfig _config;
    private final EventClient _eventClient;
    private final SDKReadinessGates _gates;

    public SplitClientImpl(SplitFactory container, SplitFetcher splitFetcher, ImpressionListener impressionListener, Metrics metrics, EventClient eventClient, SplitClientConfig config, SDKReadinessGates gates) {
        this._container = container;
        this._splitFetcher = splitFetcher;
        this._impressionListener = impressionListener;
        this._metrics = metrics;
        this._eventClient = eventClient;
        this._config = config;
        this._gates = gates;
        Preconditions.checkNotNull((Object)gates);
        Preconditions.checkNotNull((Object)this._splitFetcher);
        Preconditions.checkNotNull((Object)this._impressionListener);
    }

    @Override
    public void destroy() {
        this._container.destroy();
    }

    @Override
    public String getTreatment(String key, String split) {
        return this.getTreatment(key, split, Collections.emptyMap());
    }

    @Override
    public String getTreatment(String key, String split, Map<String, Object> attributes) {
        return this.getTreatment(key, null, split, attributes);
    }

    @Override
    public String getTreatment(Key key, String split, Map<String, Object> attributes) {
        if (key == null) {
            _log.warn("key object was null for feature: " + split);
            return "control";
        }
        if (key.matchingKey() == null || key.bucketingKey() == null) {
            _log.warn("key object had null matching or bucketing key: " + split);
            return "control";
        }
        return this.getTreatment(key.matchingKey(), key.bucketingKey(), split, attributes);
    }

    private String getTreatment(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) {
        try {
            if (matchingKey == null) {
                _log.warn("matchingKey was null for split: " + split);
                return "control";
            }
            if (split == null) {
                _log.warn("split was null for key: " + matchingKey);
                return "control";
            }
            long start = System.currentTimeMillis();
            TreatmentLabelAndChangeNumber result = this.getTreatmentResultWithoutImpressions(matchingKey, bucketingKey, split, attributes);
            this.recordStats(matchingKey, bucketingKey, split, start, result._treatment, "sdk.getTreatment", this._config.labelsEnabled() ? result._label : null, result._changeNumber, attributes);
            return result._treatment;
        }
        catch (Exception e) {
            try {
                _log.error("CatchAll Exception", (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "control";
        }
    }

    private void recordStats(String matchingKey, String bucketingKey, String split, long start, String result, String operation, String label, Long changeNumber, Map<String, Object> attributes) {
        try {
            this._impressionListener.log(new Impression(matchingKey, bucketingKey, split, result, System.currentTimeMillis(), label, changeNumber, attributes));
            this._metrics.time(operation, System.currentTimeMillis() - start);
        }
        catch (Throwable t) {
            _log.error("Exception", t);
        }
    }

    public String getTreatmentWithoutImpressions(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) {
        return this.getTreatmentResultWithoutImpressions(matchingKey, bucketingKey, split, attributes)._treatment;
    }

    private TreatmentLabelAndChangeNumber getTreatmentResultWithoutImpressions(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) {
        TreatmentLabelAndChangeNumber result;
        try {
            result = this.getTreatmentWithoutExceptionHandling(matchingKey, bucketingKey, split, attributes);
        }
        catch (ChangeNumberExceptionWrapper e) {
            result = new TreatmentLabelAndChangeNumber("control", EXCEPTION, e.changeNumber());
            _log.error("Exception", (Throwable)e.wrappedException());
        }
        catch (Exception e) {
            result = new TreatmentLabelAndChangeNumber("control", EXCEPTION);
            _log.error("Exception", (Throwable)e);
        }
        return result;
    }

    private TreatmentLabelAndChangeNumber getTreatmentWithoutExceptionHandling(String matchingKey, String bucketingKey, String split, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        ParsedSplit parsedSplit = this._splitFetcher.fetch(split);
        if (parsedSplit == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Returning control because no split was found for: " + split);
            }
            return new TreatmentLabelAndChangeNumber("control", DEFINITION_NOT_FOUND);
        }
        return this.getTreatment(matchingKey, bucketingKey, parsedSplit, attributes);
    }

    private TreatmentLabelAndChangeNumber getTreatment(String matchingKey, String bucketingKey, ParsedSplit parsedSplit, Map<String, Object> attributes) throws ChangeNumberExceptionWrapper {
        try {
            if (parsedSplit.killed()) {
                return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), KILLED, parsedSplit.changeNumber());
            }
            boolean inRollout = false;
            String bk = bucketingKey == null ? matchingKey : bucketingKey;
            for (ParsedCondition parsedCondition : parsedSplit.parsedConditions()) {
                if (!inRollout && parsedCondition.conditionType() == ConditionType.ROLLOUT) {
                    int bucket;
                    if (parsedSplit.trafficAllocation() < 100 && (bucket = Splitter.getBucket(bk, parsedSplit.trafficAllocationSeed(), parsedSplit.algo())) > parsedSplit.trafficAllocation()) {
                        return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), NOT_IN_SPLIT, parsedSplit.changeNumber());
                    }
                    inRollout = true;
                }
                if (!parsedCondition.matcher().match(matchingKey, bucketingKey, attributes, this)) continue;
                String treatment = Splitter.getTreatment(bk, parsedSplit.seed(), parsedCondition.partitions(), parsedSplit.algo());
                return new TreatmentLabelAndChangeNumber(treatment, parsedCondition.label(), parsedSplit.changeNumber());
            }
            return new TreatmentLabelAndChangeNumber(parsedSplit.defaultTreatment(), DEFAULT_RULE, parsedSplit.changeNumber());
        }
        catch (Exception e) {
            throw new ChangeNumberExceptionWrapper(e, parsedSplit.changeNumber());
        }
    }

    @Override
    public boolean track(String key, String trafficType, String eventType) {
        Event event = this.createEvent(key, trafficType, eventType);
        return this.track(event);
    }

    @Override
    public boolean track(String key, String trafficType, String eventType, double value) {
        Event event = this.createEvent(key, trafficType, eventType);
        event.value = value;
        return this.track(event);
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        long startTime = System.currentTimeMillis();
        if (this._config.blockUntilReady() <= 0) {
            throw new IllegalArgumentException("setBlockUntilReadyTimeout must be positive but in config was: " + this._config.blockUntilReady());
        }
        if (!this._gates.isSDKReady(this._config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + this._config.blockUntilReady() + " milliseconds");
        }
        _log.debug(String.format("Split SDK ready in %d ms", System.currentTimeMillis() - startTime));
    }

    private Event createEvent(String key, String trafficType, String eventType) {
        Event event = new Event();
        event.eventTypeId = eventType;
        event.trafficTypeName = trafficType;
        event.key = key;
        event.timestamp = System.currentTimeMillis();
        return event;
    }

    private boolean track(Event event) {
        if (Strings.isNullOrEmpty((String)event.trafficTypeName)) {
            _log.warn("Traffic Type was null or empty");
            return false;
        }
        if (Strings.isNullOrEmpty((String)event.eventTypeId)) {
            _log.warn("Event Type was null or empty");
            return false;
        }
        if (Strings.isNullOrEmpty((String)event.key)) {
            _log.warn("Cannot track event for null key");
            return false;
        }
        return this._eventClient.track(event);
    }

    private static final class TreatmentLabelAndChangeNumber {
        private final String _treatment;
        private final String _label;
        private final Long _changeNumber;

        public TreatmentLabelAndChangeNumber(String treatment, String label) {
            this(treatment, label, null);
        }

        public TreatmentLabelAndChangeNumber(String treatment, String label, Long changeNumber) {
            this._treatment = treatment;
            this._label = label;
            this._changeNumber = changeNumber;
        }
    }
}

