/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.utils;

public final class MurmurHash3 {
    public static final int fmix32(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    public static final long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    public static final long getLongLittleEndian(byte[] buf, int offset) {
        return (long)buf[offset + 7] << 56 | ((long)buf[offset + 6] & 0xFFL) << 48 | ((long)buf[offset + 5] & 0xFFL) << 40 | ((long)buf[offset + 4] & 0xFFL) << 32 | ((long)buf[offset + 3] & 0xFFL) << 24 | ((long)buf[offset + 2] & 0xFFL) << 16 | ((long)buf[offset + 1] & 0xFFL) << 8 | (long)buf[offset] & 0xFFL;
    }

    public static long murmurhash3_x86_32(CharSequence data, int offset, int len, int seed) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = seed;
        int pos = offset;
        int end = offset + len;
        int k1 = 0;
        int k2 = 0;
        int shift = 0;
        int bits = 0;
        int nBytes = 0;
        while (pos < end) {
            int code;
            if ((code = data.charAt(pos++)) < 128) {
                k2 = code;
                bits = 8;
            } else if (code < 2048) {
                k2 = 0xC0 | code >> 6 | (0x80 | code & 0x3F) << 8;
                bits = 16;
            } else if (code < 55296 || code > 57343 || pos >= end) {
                k2 = 0xE0 | code >> 12 | (0x80 | code >> 6 & 0x3F) << 8 | (0x80 | code & 0x3F) << 16;
                bits = 24;
            } else {
                int utf32 = data.charAt(pos++);
                utf32 = (code - 55232 << 10) + (utf32 & 0x3FF);
                k2 = 0xFF & (0xF0 | utf32 >> 18) | (0x80 | utf32 >> 12 & 0x3F) << 8 | (0x80 | utf32 >> 6 & 0x3F) << 16 | (0x80 | utf32 & 0x3F) << 24;
                bits = 32;
            }
            k1 |= k2 << shift;
            if ((shift += bits) < 32) continue;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
            k1 = (shift -= 32) != 0 ? k2 >>> bits - shift : 0;
            nBytes += 4;
        }
        if (shift > 0) {
            nBytes += shift >> 3;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
        }
        h1 ^= nBytes;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return (long)h1 & 0xFFFFFFFFL;
    }

    public static final class LongPair {
        public long val1;
        public long val2;
    }
}

