/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.KeyImpression;
import io.split.client.impressions.ImpressionHasher;
import split.com.google.common.cache.Cache;
import split.com.google.common.cache.CacheBuilder;
import split.org.apache.http.annotation.NotThreadSafe;

@NotThreadSafe
public class ImpressionObserver {
    private final Cache<Long, Long> _cache;

    public ImpressionObserver(long size) {
        this._cache = CacheBuilder.newBuilder().maximumSize(size).concurrencyLevel(4).build();
    }

    public Long testAndSet(KeyImpression impression) {
        if (null == impression) {
            return null;
        }
        Long hash = ImpressionHasher.process(impression);
        Long previous = this._cache.getIfPresent(hash);
        this._cache.put(hash, impression.time);
        return previous;
    }
}

