/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.engine.sse.EventSourceClient;
import io.split.engine.sse.SseStatus;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.sse.InboundSseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.glassfish.jersey.media.sse.EventInput;
import split.org.glassfish.jersey.media.sse.InboundEvent;

public class SplitSseEventSource {
    private static final Logger _log = LoggerFactory.getLogger(EventSourceClient.class);
    private static final String SERVER_SENT_EVENTS = "text/event-stream";
    private final AtomicReference<SseState> _state = new AtomicReference<SseState>(SseState.CLOSED);
    private final Function<InboundSseEvent, Void> _eventCallback;
    private final ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private CountDownLatch _firstContactSignal;
    private final Function<SseStatus, Void> _sseStatusHandler;
    private EventInput _eventInput;

    public SplitSseEventSource(Function<InboundSseEvent, Void> eventCallback, Function<SseStatus, Void> sseStatusHandler) {
        this._eventCallback = eventCallback;
        this._sseStatusHandler = sseStatusHandler;
    }

    public boolean open(WebTarget target) {
        if (this.isOpen()) {
            throw new IllegalStateException("Event Source Already connected.");
        }
        this._firstContactSignal = new CountDownLatch(1);
        this._executor.execute(() -> this.run(target));
        this.awaitFirstContact();
        return this.isOpen();
    }

    public boolean isOpen() {
        return this._state.get() == SseState.OPEN;
    }

    public void close() {
        if (!this.isOpen()) {
            _log.warn("SplitSseEventSource already closed.");
            return;
        }
        this._state.set(SseState.CLOSED);
        this._eventInput.close();
        _log.debug(String.format("SplitSseEventSource.close final state: %s", new Object[]{this._state.get()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(WebTarget target) {
        try {
            try {
                Invocation.Builder request = target.request(SERVER_SENT_EVENTS);
                this._eventInput = request.get(EventInput.class);
                if (this._eventInput != null && !this._eventInput.isClosed()) {
                    this._sseStatusHandler.apply(SseStatus.CONNECTED);
                    this._state.set(SseState.OPEN);
                }
            }
            finally {
                if (this._firstContactSignal != null) {
                    this._firstContactSignal.countDown();
                }
            }
            while (this.isOpen() && !Thread.currentThread().isInterrupted() && null != this._eventInput && !this._eventInput.isClosed()) {
                InboundEvent e = (InboundEvent)this._eventInput.read();
                if (null == e && this.isOpen()) {
                    this._sseStatusHandler.apply(SseStatus.RETRYABLE_ERROR);
                    return;
                }
                this._eventCallback.apply(e);
            }
            this._sseStatusHandler.apply(SseStatus.DISCONNECTED);
        }
        catch (WebApplicationException wae) {
            _log.warn(wae.getMessage());
            if (wae.getResponse().getStatus() >= 400 && wae.getResponse().getStatus() < 500) {
                this._sseStatusHandler.apply(SseStatus.NONRETRYABLE_ERROR);
            } else {
                this._sseStatusHandler.apply(SseStatus.RETRYABLE_ERROR);
            }
        }
        catch (Exception exc) {
            this._sseStatusHandler.apply(SseStatus.NONRETRYABLE_ERROR);
            _log.warn(exc.getMessage());
        }
        finally {
            if (this._eventInput != null) {
                this._eventInput.close();
            }
            this._state.set(SseState.CLOSED);
            _log.debug("SSE connection finished.");
        }
    }

    private void awaitFirstContact() {
        _log.debug("Awaiting first contact signal.");
        try {
            if (this._firstContactSignal == null) {
                return;
            }
            try {
                this._firstContactSignal.await();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            _log.debug("First contact signal released.");
        }
    }

    public static enum SseState {
        OPEN,
        CLOSED;

    }
}

