/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse.dtos;

import io.split.engine.sse.NotificationProcessor;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.dtos.ControlType;
import io.split.engine.sse.dtos.GenericNotificationData;
import io.split.engine.sse.dtos.IncomingNotification;
import io.split.engine.sse.dtos.StatusNotification;

public class ControlNotification
extends IncomingNotification
implements StatusNotification {
    private final ControlType controlType;

    public ControlNotification(GenericNotificationData genericNotificationData) {
        super(IncomingNotification.Type.CONTROL, genericNotificationData.getChannel());
        this.controlType = genericNotificationData.getControlType();
    }

    public ControlType getControlType() {
        return this.controlType;
    }

    @Override
    public void handler(NotificationProcessor notificationProcessor) {
        notificationProcessor.processStatus(this);
    }

    @Override
    public void handlerStatus(PushStatusTracker pushStatusTracker) {
        pushStatusTracker.handleIncomingControlEvent(this);
    }

    public String toString() {
        return String.format("Type: %s; Channel: %s; ControlType: %s", new Object[]{this.getType(), this.getChannel(), this.getControlType()});
    }
}

