/*
 * Decompiled with CFR 0.152.
 */
package split.org.glassfish.jersey.server;

import split.org.glassfish.jersey.internal.BootstrapBag;
import split.org.glassfish.jersey.internal.inject.Bindings;
import split.org.glassfish.jersey.internal.inject.InjectionManager;
import split.org.glassfish.jersey.internal.inject.InstanceBinding;
import split.org.glassfish.jersey.model.internal.ComponentBag;
import split.org.glassfish.jersey.model.internal.ManagedObjectsFinalizer;
import split.org.glassfish.jersey.process.internal.AbstractExecutorProvidersConfigurator;
import split.org.glassfish.jersey.server.BackgroundScheduler;
import split.org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import split.org.glassfish.jersey.server.ManagedAsyncExecutor;
import split.org.glassfish.jersey.server.ResourceConfig;
import split.org.glassfish.jersey.server.ServerBootstrapBag;
import split.org.glassfish.jersey.spi.ExecutorServiceProvider;
import split.org.glassfish.jersey.spi.ScheduledExecutorServiceProvider;
import split.org.glassfish.jersey.spi.ScheduledThreadPoolExecutorProvider;
import split.org.glassfish.jersey.spi.ThreadPoolExecutorProvider;

class ServerExecutorProvidersConfigurator
extends AbstractExecutorProvidersConfigurator {
    ServerExecutorProvidersConfigurator() {
    }

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        ResourceConfig runtimeConfig = serverBag.getRuntimeConfig();
        ComponentBag componentBag = runtimeConfig.getComponentBag();
        ManagedObjectsFinalizer finalizer = serverBag.getManagedObjectsFinalizer();
        DefaultBackgroundSchedulerProvider defaultScheduledExecutorProvider = new DefaultBackgroundSchedulerProvider();
        InstanceBinding schedulerBinding = (InstanceBinding)((InstanceBinding)Bindings.service(defaultScheduledExecutorProvider).to(ScheduledExecutorServiceProvider.class)).qualifiedBy(BackgroundSchedulerLiteral.INSTANCE);
        injectionManager.register(schedulerBinding);
        finalizer.registerForPreDestroyCall(defaultScheduledExecutorProvider);
        DefaultManagedAsyncExecutorProvider defaultAsyncExecutorProvider = new DefaultManagedAsyncExecutorProvider();
        InstanceBinding executorBinding = (InstanceBinding)Bindings.service(defaultAsyncExecutorProvider).to(ExecutorServiceProvider.class);
        injectionManager.register(executorBinding);
        finalizer.registerForPreDestroyCall(defaultAsyncExecutorProvider);
        this.registerExecutors(injectionManager, componentBag, defaultAsyncExecutorProvider, defaultScheduledExecutorProvider);
    }

    @ManagedAsyncExecutor
    private static class DefaultManagedAsyncExecutorProvider
    extends ThreadPoolExecutorProvider {
        public DefaultManagedAsyncExecutorProvider() {
            super("jersey-server-managed-async-executor");
        }
    }

    @BackgroundScheduler
    private static class DefaultBackgroundSchedulerProvider
    extends ScheduledThreadPoolExecutorProvider {
        public DefaultBackgroundSchedulerProvider() {
            super("jersey-background-task-scheduler");
        }

        @Override
        protected int getCorePoolSize() {
            return 1;
        }
    }
}

