/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SegmentChange;
import io.split.client.utils.Json;
import io.split.client.utils.Utils;
import io.split.engine.metrics.Metrics;
import io.split.engine.segments.SegmentChangeFetcher;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpGet;
import split.org.apache.http.client.utils.URIBuilder;
import split.org.apache.http.impl.client.CloseableHttpClient;
import split.org.apache.http.util.EntityUtils;

public final class HttpSegmentChangeFetcher
implements SegmentChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(HttpSegmentChangeFetcher.class);
    private static final String SINCE = "since";
    private static final String PREFIX = "segmentChangeFetcher";
    private final CloseableHttpClient _client;
    private final URI _target;
    private final Metrics _metrics;

    public static HttpSegmentChangeFetcher create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return HttpSegmentChangeFetcher.create(client, root, new Metrics.NoopMetrics());
    }

    public static HttpSegmentChangeFetcher create(CloseableHttpClient client, URI root, Metrics metrics) throws URISyntaxException {
        return new HttpSegmentChangeFetcher(client, Utils.appendPath(root, "api/segmentChanges"), metrics);
    }

    private HttpSegmentChangeFetcher(CloseableHttpClient client, URI uri, Metrics metrics) {
        this._client = client;
        this._target = uri;
        this._metrics = metrics;
        Preconditions.checkNotNull(this._target);
    }

    @Override
    public SegmentChange fetch(String segmentName, long since) {
        SegmentChange segmentChange;
        long start = System.currentTimeMillis();
        CloseableHttpResponse response = null;
        try {
            String path = this._target.getPath() + "/" + segmentName;
            URI uri = new URIBuilder(this._target).setPath(path).addParameter(SINCE, "" + since).build();
            HttpGet request = new HttpGet(uri);
            response = this._client.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                _log.error("Response status was: " + statusCode);
                if (statusCode == 403) {
                    _log.error("factory instantiation: you passed a browser type api_key, please grab an api key from the Split console that is of type sdk");
                }
                this._metrics.count("segmentChangeFetcher.status." + statusCode, 1L);
                throw new IllegalStateException("Could not retrieve segment changes for " + segmentName + "; http return code " + statusCode);
            }
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            if (_log.isDebugEnabled()) {
                _log.debug("Received json: " + json);
            }
            segmentChange = Json.fromJson(json, SegmentChange.class);
        }
        catch (Throwable t) {
            try {
                this._metrics.count("segmentChangeFetcher.exception", 1L);
                throw new IllegalStateException("Problem fetching segmentChanges: " + t.getMessage(), t);
            }
            catch (Throwable throwable) {
                Utils.forceClose(response);
                this._metrics.time("segmentChangeFetcher.time", System.currentTimeMillis() - start);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        this._metrics.time("segmentChangeFetcher.time", System.currentTimeMillis() - start);
        return segmentChange;
    }

    @VisibleForTesting
    URI getTarget() {
        return this._target;
    }
}

