/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.impressions;

import io.split.client.dtos.ImpressionCount;
import io.split.client.dtos.TestImpressions;
import io.split.client.impressions.ImpressionCounter;
import io.split.client.impressions.ImpressionsManager;
import io.split.client.impressions.ImpressionsSender;
import io.split.client.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.org.apache.http.client.methods.CloseableHttpResponse;
import split.org.apache.http.client.methods.HttpPost;
import split.org.apache.http.entity.StringEntity;
import split.org.apache.http.impl.client.CloseableHttpClient;

public class HttpImpressionsSender
implements ImpressionsSender {
    private static final String BULK_ENDPOINT_PATH = "api/testImpressions/bulk";
    private static final String COUNT_ENDPOINT_PATH = "api/testImpressions/count";
    private static final String IMPRESSIONS_MODE_HEADER = "SplitSDKImpressionsMode";
    private static final Logger _logger = LoggerFactory.getLogger(HttpImpressionsSender.class);
    private final CloseableHttpClient _client;
    private final URI _impressionBulkTarget;
    private final URI _impressionCountTarget;
    private final ImpressionsManager.Mode _mode;

    public static HttpImpressionsSender create(CloseableHttpClient client, URI eventsRootEndpoint, ImpressionsManager.Mode mode) throws URISyntaxException {
        return new HttpImpressionsSender(client, Utils.appendPath(eventsRootEndpoint, BULK_ENDPOINT_PATH), Utils.appendPath(eventsRootEndpoint, COUNT_ENDPOINT_PATH), mode);
    }

    private HttpImpressionsSender(CloseableHttpClient client, URI impressionBulkTarget, URI impressionCountTarget, ImpressionsManager.Mode mode) {
        this._client = client;
        this._mode = mode;
        this._impressionBulkTarget = impressionBulkTarget;
        this._impressionCountTarget = impressionCountTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postImpressionsBulk(List<TestImpressions> impressions) {
        CloseableHttpResponse response;
        block5: {
            response = null;
            try {
                StringEntity entity = Utils.toJsonEntity(impressions);
                HttpPost request = new HttpPost(this._impressionBulkTarget);
                request.addHeader(IMPRESSIONS_MODE_HEADER, this._mode.toString());
                request.setEntity(entity);
                response = this._client.execute(request);
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) break block5;
                _logger.warn("Response status was: " + status);
            }
            catch (Throwable t) {
                try {
                    _logger.warn("Exception when posting impressions" + impressions, t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Utils.forceClose(response);
                }
            }
        }
        Utils.forceClose(response);
    }

    @Override
    public void postCounters(HashMap<ImpressionCounter.Key, Integer> raw) {
        if (this._mode.equals((Object)ImpressionsManager.Mode.DEBUG)) {
            _logger.warn("Attempted to submit counters in impressions debugging mode. Ignoring");
            return;
        }
        HttpPost request = new HttpPost(this._impressionCountTarget);
        request.setEntity(Utils.toJsonEntity(ImpressionCount.fromImpressionCounterData(raw)));
        try (CloseableHttpResponse response = this._client.execute(request);){
            int status = response.getStatusLine().getStatusCode();
            if (status < 200 || status >= 300) {
                _logger.warn("Response status was: " + status);
            }
        }
        catch (IOException exc) {
            _logger.warn("Exception when posting impression counters: ", (Throwable)exc);
        }
    }

    @VisibleForTesting
    URI getTarget() {
        return this._impressionBulkTarget;
    }
}

