/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.experiments;

import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.RefreshableSplitFetcher;
import io.split.engine.experiments.SplitChangeFetcher;
import io.split.engine.experiments.SplitParser;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class RefreshableSplitFetcherProvider
implements Closeable {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSplitFetcherProvider.class);
    private final SplitParser _splitParser;
    private final SplitChangeFetcher _splitChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final AtomicReference<RefreshableSplitFetcher> _splitFetcher = new AtomicReference();
    private final SDKReadinessGates _gates;
    private final AtomicReference<ScheduledExecutorService> _executorService = new AtomicReference();
    private final ScheduledExecutorService _scheduledExecutorService;
    private final Object _lock = new Object();
    private final AtomicBoolean _running;
    private ScheduledFuture<?> _scheduledFuture;

    public RefreshableSplitFetcherProvider(SplitChangeFetcher splitChangeFetcher, SplitParser splitParser, long refreshEveryNSeconds, SDKReadinessGates sdkBuildBlocker) {
        this._splitChangeFetcher = splitChangeFetcher;
        Preconditions.checkNotNull(this._splitChangeFetcher);
        this._splitParser = splitParser;
        Preconditions.checkNotNull(this._splitParser);
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        this._gates = sdkBuildBlocker;
        Preconditions.checkNotNull(this._gates);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("split-splitFetcher-%d").build();
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this._executorService.set(this._scheduledExecutorService);
        this._running = new AtomicBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefreshableSplitFetcher getFetcher() {
        if (this._splitFetcher.get() != null) {
            return this._splitFetcher.get();
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._splitFetcher.get() != null) {
                return this._splitFetcher.get();
            }
            RefreshableSplitFetcher splitFetcher = new RefreshableSplitFetcher(this._splitChangeFetcher, this._splitParser, this._gates);
            this._splitFetcher.set(splitFetcher);
            return splitFetcher;
        }
    }

    public void startPeriodicFetching() {
        if (this._running.getAndSet(true)) {
            _log.warn("Splits PeriodicFetching is running...");
            return;
        }
        _log.debug("Starting PeriodicFetching Splits ...");
        this._scheduledFuture = this._scheduledExecutorService.scheduleWithFixedDelay(this.getFetcher(), 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (!this._running.getAndSet(false) || this._scheduledFuture == null) {
            _log.warn("Splits PeriodicFetching not running...");
            return;
        }
        this._scheduledFuture.cancel(false);
        _log.debug("Stopped PeriodicFetching Splits ...");
    }

    @Override
    public void close() {
        ScheduledExecutorService scheduledExecutorService;
        if (this._executorService.get() == null) {
            return;
        }
        if (this._splitFetcher.get() != null) {
            this._splitFetcher.get().clear();
        }
        if ((scheduledExecutorService = this._executorService.get()).isShutdown()) {
            return;
        }
        scheduledExecutorService.shutdown();
        try {
            if (!scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.warn("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = scheduledExecutorService.shutdownNow();
                _log.warn("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.warn("Shutdown hook for split fetchers has been interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

