/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.EventClientImpl;
import io.split.client.HttpSegmentChangeFetcher;
import io.split.client.HttpSplitChangeFetcher;
import io.split.client.SplitClient;
import io.split.client.SplitClientConfig;
import io.split.client.SplitClientImpl;
import io.split.client.SplitFactory;
import io.split.client.SplitManager;
import io.split.client.SplitManagerImpl;
import io.split.client.impressions.AsynchronousImpressionListener;
import io.split.client.impressions.ImpressionListener;
import io.split.client.impressions.ImpressionsManagerImpl;
import io.split.client.interceptors.AddSplitHeadersFilter;
import io.split.client.interceptors.GzipDecoderResponseInterceptor;
import io.split.client.interceptors.GzipEncoderRequestInterceptor;
import io.split.client.metrics.CachedMetrics;
import io.split.client.metrics.DTOMetrics;
import io.split.client.metrics.FireAndForgetMetrics;
import io.split.client.metrics.HttpMetrics;
import io.split.engine.SDKReadinessGates;
import io.split.engine.common.SyncManagerImp;
import io.split.engine.experiments.RefreshableSplitFetcherProvider;
import io.split.engine.experiments.SplitParser;
import io.split.engine.segments.RefreshableSegmentFetcher;
import io.split.integrations.IntegrationsConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.ConcurrentHashMultiset;
import split.com.google.common.collect.Multiset;

public class SplitFactoryImpl
implements SplitFactory {
    private static final Logger _log = LoggerFactory.getLogger(SplitFactory.class);
    private static final long SSE_CONNECT_TIMEOUT = 30000L;
    private static final long SSE_SOCKET_TIMEOUT = 70000L;
    private static final Multiset<String> USED_API_TOKENS = ConcurrentHashMultiset.create();
    private static Random RANDOM = new Random();
    private final SplitClient _client;
    private final SplitManager _manager;
    private final Runnable destroyer;
    private final String _apiToken;
    private boolean isTerminated = false;

    private static CloseableHttpClient buildHttpClient(String apiToken, SplitClientConfig config) {
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_1, TLS.V_1_2}).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.connectionTimeout())).setCookieSpec("strict").build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)config.readTimeout())).build()).build();
        cm.setMaxTotal(20);
        cm.setDefaultMaxPerRoute(20);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).addRequestInterceptorLast((HttpRequestInterceptor)AddSplitHeadersFilter.instance(apiToken, config.ipAddressEnabled())).addRequestInterceptorLast((HttpRequestInterceptor)new GzipEncoderRequestInterceptor()).addResponseInterceptorLast((HttpResponseInterceptor)new GzipDecoderResponseInterceptor());
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static CloseableHttpClient buildSSEdHttpClient(SplitClientConfig config) {
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)30000L)).build();
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContexts.createSystemDefault()).setTlsVersions(new TLS[]{TLS.V_1_1, TLS.V_1_2}).build();
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(Timeout.ofMilliseconds((long)70000L)).build()).build();
        cm.setMaxTotal(1);
        cm.setDefaultMaxPerRoute(1);
        HttpClientBuilder httpClientbuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig);
        if (config.proxy() != null) {
            httpClientbuilder = SplitFactoryImpl.setupProxy(httpClientbuilder, config);
        }
        return httpClientbuilder.build();
    }

    private static HttpClientBuilder setupProxy(HttpClientBuilder httpClientbuilder, SplitClientConfig config) {
        _log.info("Initializing Split SDK with proxy settings");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(config.proxy());
        httpClientbuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (config.proxyUsername() != null && config.proxyPassword() != null) {
            _log.debug("Proxy setup using credentials");
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            AuthScope siteScope = new AuthScope(config.proxy().getHostName(), config.proxy().getPort());
            UsernamePasswordCredentials siteCreds = new UsernamePasswordCredentials(config.proxyUsername(), config.proxyPassword().toCharArray());
            credsProvider.setCredentials(siteScope, (Credentials)siteCreds);
            httpClientbuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        }
        return httpClientbuilder;
    }

    public SplitFactoryImpl(String apiToken, SplitClientConfig config) throws URISyntaxException {
        String message;
        this._apiToken = apiToken;
        if (USED_API_TOKENS.contains(apiToken)) {
            message = String.format("factory instantiation: You already have %s with this API Key. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.", USED_API_TOKENS.count(apiToken) == 1 ? "1 factory" : String.format("%s factories", USED_API_TOKENS.count(apiToken)));
            _log.warn(message);
        } else if (!USED_API_TOKENS.isEmpty()) {
            message = "factory instantiation: You already have an instance of the Split factory. Make sure you definitely want this additional instance. We recommend keeping only one instance of the factory at all times (Singleton pattern) and reusing it throughout your application.\u201c";
            _log.warn(message);
        }
        USED_API_TOKENS.add(apiToken);
        if (config.blockUntilReady() == -1) {
            _log.warn("no setBlockUntilReadyTimeout parameter has been set - incorrect control treatments could be logged\u201d if no ready config has been set when building factory");
        }
        final CloseableHttpClient httpclient = SplitFactoryImpl.buildHttpClient(apiToken, config);
        URI rootTarget = URI.create(config.endpoint());
        URI eventsRootTarget = URI.create(config.eventsEndpoint());
        HttpMetrics httpMetrics = HttpMetrics.create(httpclient, eventsRootTarget);
        final FireAndForgetMetrics uncachedFireAndForget = FireAndForgetMetrics.instance(httpMetrics, 2, 1000);
        SDKReadinessGates gates = new SDKReadinessGates();
        HttpSegmentChangeFetcher segmentChangeFetcher = HttpSegmentChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSegmentFetcher segmentFetcher = new RefreshableSegmentFetcher(segmentChangeFetcher, SplitFactoryImpl.findPollingPeriod(RANDOM, config.segmentsRefreshRate()), config.numThreadsForSegmentFetch(), gates);
        SplitParser splitParser = new SplitParser(segmentFetcher);
        HttpSplitChangeFetcher splitChangeFetcher = HttpSplitChangeFetcher.create(httpclient, rootTarget, uncachedFireAndForget);
        final RefreshableSplitFetcherProvider splitFetcherProvider = new RefreshableSplitFetcherProvider(splitChangeFetcher, splitParser, SplitFactoryImpl.findPollingPeriod(RANDOM, config.featuresRefreshRate()), gates);
        ArrayList<ImpressionListener> impressionListeners = new ArrayList<ImpressionListener>();
        if (config.integrationsConfig() != null) {
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.ASYNC).stream().map(l -> AsynchronousImpressionListener.build(l.listener(), l.queueSize())).collect(Collectors.toCollection(() -> impressionListeners));
            config.integrationsConfig().getImpressionsListeners(IntegrationsConfig.Execution.SYNC).stream().map(IntegrationsConfig.ImpressionListenerWithMeta::listener).collect(Collectors.toCollection(() -> impressionListeners));
        }
        final ImpressionsManagerImpl impressionsManager = ImpressionsManagerImpl.instance(httpclient, config, impressionListeners);
        CachedMetrics cachedMetrics = new CachedMetrics((DTOMetrics)httpMetrics, TimeUnit.SECONDS.toMillis(config.metricsRefreshRate()));
        final FireAndForgetMetrics cachedFireAndForgetMetrics = FireAndForgetMetrics.instance(cachedMetrics, 2, 1000);
        final EventClientImpl eventClient = EventClientImpl.create(httpclient, eventsRootTarget, config.eventsQueueSize(), config.eventFlushIntervalInMillis(), config.waitBeforeShutdown());
        final SyncManagerImp syncManager = SyncManagerImp.build(config.streamingEnabled(), splitFetcherProvider, segmentFetcher, config.authServiceURL(), httpclient, config.streamingServiceURL(), config.authRetryBackoffBase(), SplitFactoryImpl.buildSSEdHttpClient(config));
        syncManager.start();
        this.destroyer = new Runnable(){

            @Override
            public void run() {
                _log.info("Shutdown called for split");
                try {
                    segmentFetcher.close();
                    _log.info("Successful shutdown of segment fetchers");
                    splitFetcherProvider.close();
                    _log.info("Successful shutdown of splits");
                    impressionsManager.close();
                    _log.info("Successful shutdown of impressions manager");
                    uncachedFireAndForget.close();
                    _log.info("Successful shutdown of metrics 1");
                    cachedFireAndForgetMetrics.close();
                    _log.info("Successful shutdown of metrics 2");
                    httpclient.close();
                    _log.info("Successful shutdown of httpclient");
                    eventClient.close();
                    _log.info("Successful shutdown of httpclient");
                    new Thread(syncManager::shutdown).start();
                    _log.info("Successful shutdown of syncManager");
                }
                catch (IOException e) {
                    _log.error("We could not shutdown split", (Throwable)e);
                }
            }
        };
        if (config.destroyOnShutDown()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SplitFactoryImpl.this.destroy();
                }
            });
        }
        this._client = new SplitClientImpl(this, splitFetcherProvider.getFetcher(), impressionsManager, cachedFireAndForgetMetrics, eventClient, config, gates);
        this._manager = new SplitManagerImpl(splitFetcherProvider.getFetcher(), config, gates);
    }

    private static int findPollingPeriod(Random rand, int max) {
        int min = max / 2;
        return rand.nextInt(max - min + 1) + min;
    }

    @Override
    public SplitClient client() {
        return this._client;
    }

    @Override
    public SplitManager manager() {
        return this._manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Class<SplitFactoryImpl> clazz = SplitFactoryImpl.class;
        synchronized (SplitFactoryImpl.class) {
            if (!this.isTerminated) {
                this.destroyer.run();
                USED_API_TOKENS.remove(this._apiToken);
                this.isTerminated = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.isTerminated;
    }
}

