/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.common;

import io.split.engine.common.Backoff;
import io.split.engine.common.PushManager;
import io.split.engine.common.Synchronizer;
import io.split.engine.sse.AuthApiClient;
import io.split.engine.sse.AuthApiClientImp;
import io.split.engine.sse.EventSourceClient;
import io.split.engine.sse.EventSourceClientImp;
import io.split.engine.sse.PushStatusTracker;
import io.split.engine.sse.PushStatusTrackerImp;
import io.split.engine.sse.dtos.AuthenticationResponse;
import io.split.engine.sse.dtos.SegmentQueueDto;
import io.split.engine.sse.workers.SegmentsWorkerImp;
import io.split.engine.sse.workers.SplitsWorker;
import io.split.engine.sse.workers.SplitsWorkerImp;
import io.split.engine.sse.workers.Worker;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class PushManagerImp
implements PushManager {
    private static final Logger _log = LoggerFactory.getLogger(PushManager.class);
    private final AuthApiClient _authApiClient;
    private final EventSourceClient _eventSourceClient;
    private final Backoff _backoff;
    private final SplitsWorker _splitsWorker;
    private final Worker<SegmentQueueDto> _segmentWorker;
    private final PushStatusTracker _pushStatusTracker;
    private Future<?> _nextTokenRefreshTask;
    private final ScheduledExecutorService _scheduledExecutorService;

    @VisibleForTesting
    PushManagerImp(AuthApiClient authApiClient, EventSourceClient eventSourceClient, SplitsWorker splitsWorker, Worker<SegmentQueueDto> segmentWorker, Backoff backoff, PushStatusTracker pushStatusTracker) {
        this._authApiClient = Preconditions.checkNotNull(authApiClient);
        this._eventSourceClient = Preconditions.checkNotNull(eventSourceClient);
        this._backoff = Preconditions.checkNotNull(backoff);
        this._splitsWorker = splitsWorker;
        this._segmentWorker = segmentWorker;
        this._pushStatusTracker = pushStatusTracker;
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Split-SSERefreshToken-%d").build());
    }

    public static PushManagerImp build(Synchronizer synchronizer, String streamingUrl, String authUrl, CloseableHttpClient httpClient, int authRetryBackOffBase, LinkedBlockingQueue<PushManager.Status> statusMessages, CloseableHttpClient sseHttpClient) {
        SplitsWorkerImp splitsWorker = new SplitsWorkerImp(synchronizer);
        SegmentsWorkerImp segmentWorker = new SegmentsWorkerImp(synchronizer);
        PushStatusTrackerImp pushStatusTracker = new PushStatusTrackerImp(statusMessages);
        return new PushManagerImp(new AuthApiClientImp(authUrl, httpClient), EventSourceClientImp.build(streamingUrl, splitsWorker, segmentWorker, pushStatusTracker, sseHttpClient), splitsWorker, segmentWorker, new Backoff(authRetryBackOffBase), pushStatusTracker);
    }

    @Override
    public synchronized void start() {
        AuthenticationResponse response = this._authApiClient.Authenticate();
        _log.debug(String.format("Auth service response pushEnabled: %s", response.isPushEnabled()));
        if (response.isPushEnabled() && this.startSse(response.getToken(), response.getChannels())) {
            this.scheduleConnectionReset(response.getExpiration());
            this._backoff.reset();
            return;
        }
        this.stop();
        if (response.isRetry()) {
            this.scheduleConnectionReset(this._backoff.interval());
        } else {
            this._pushStatusTracker.forcePushDisable();
        }
    }

    @Override
    public synchronized void stop() {
        this._eventSourceClient.stop();
        this.stopWorkers();
        if (this._nextTokenRefreshTask != null) {
            _log.debug("Cancel nextTokenRefreshTask");
            this._nextTokenRefreshTask.cancel(false);
        }
    }

    private void scheduleConnectionReset(long time) {
        _log.debug(String.format("scheduleNextTokenRefresh in %s SECONDS", time));
        this._nextTokenRefreshTask = this._scheduledExecutorService.schedule(() -> {
            _log.debug("Starting scheduleNextTokenRefresh ...");
            this.stop();
            this.start();
        }, time, TimeUnit.SECONDS);
    }

    private boolean startSse(String token, String channels) {
        try {
            _log.debug("SSE Handler starting ...");
            return this._eventSourceClient.start(channels, token);
        }
        catch (Exception e) {
            _log.debug("Exception in SSE Handler start: " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized void startWorkers() {
        this._splitsWorker.start();
        this._segmentWorker.start();
    }

    @Override
    public synchronized void stopWorkers() {
        this._splitsWorker.stop();
        this._segmentWorker.stop();
    }
}

