/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.segments;

import io.split.engine.SDKReadinessGates;
import io.split.engine.segments.RefreshableSegment;
import io.split.engine.segments.SegmentChangeFetcher;
import io.split.engine.segments.SegmentFetcher;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Maps;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class RefreshableSegmentFetcher
implements Closeable,
SegmentFetcher,
Runnable {
    private static final Logger _log = LoggerFactory.getLogger(RefreshableSegmentFetcher.class);
    private final SegmentChangeFetcher _segmentChangeFetcher;
    private final AtomicLong _refreshEveryNSeconds;
    private final AtomicBoolean _running;
    private final Object _lock = new Object();
    private final ConcurrentMap<String, RefreshableSegment> _segmentFetchers = Maps.newConcurrentMap();
    private final SDKReadinessGates _gates;
    private final ScheduledExecutorService _scheduledExecutorService;
    private ScheduledFuture<?> _scheduledFuture;

    public RefreshableSegmentFetcher(SegmentChangeFetcher segmentChangeFetcher, long refreshEveryNSeconds, int numThreads, SDKReadinessGates gates) {
        this._segmentChangeFetcher = segmentChangeFetcher;
        Preconditions.checkNotNull(this._segmentChangeFetcher);
        Preconditions.checkArgument(refreshEveryNSeconds >= 0L);
        this._refreshEveryNSeconds = new AtomicLong(refreshEveryNSeconds);
        this._gates = gates;
        Preconditions.checkNotNull(this._gates);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("split-segmentFetcher-%d").build();
        this._scheduledExecutorService = Executors.newScheduledThreadPool(numThreads, threadFactory);
        this._running = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RefreshableSegment segment(String segmentName) {
        RefreshableSegment segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
        if (segment != null) {
            return segment;
        }
        Object object = this._lock;
        synchronized (object) {
            segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
            if (segment != null) {
                return segment;
            }
            try {
                this._gates.registerSegment(segmentName);
            }
            catch (InterruptedException e) {
                _log.error("Unable to register segment " + segmentName);
            }
            segment = RefreshableSegment.create(segmentName, this._segmentChangeFetcher, this._gates);
            if (this._running.get()) {
                this._scheduledExecutorService.submit(segment);
            }
            this._segmentFetchers.putIfAbsent(segmentName, segment);
            return segment;
        }
    }

    @Override
    public long getChangeNumber(String segmentName) {
        RefreshableSegment segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
        if (segment == null) {
            return -1L;
        }
        return segment.changeNumber();
    }

    @Override
    public void forceRefresh(String segmentName) {
        _log.debug(String.format("Fetching segment: %s ...", segmentName));
        RefreshableSegment segment = (RefreshableSegment)this._segmentFetchers.get(segmentName);
        if (segment == null) {
            return;
        }
        segment.forceRefresh();
    }

    @Override
    public void forceRefreshAll() {
        for (Map.Entry entry : this._segmentFetchers.entrySet()) {
            RefreshableSegment refreshableSegment = (RefreshableSegment)entry.getValue();
            if (refreshableSegment == null) continue;
            this._scheduledExecutorService.submit(refreshableSegment);
        }
    }

    @Override
    public void startPeriodicFetching() {
        if (this._running.getAndSet(true)) {
            _log.warn("Segments PeriodicFetching is running...");
            return;
        }
        _log.debug("Starting PeriodicFetching Segments ...");
        this._scheduledFuture = this._scheduledExecutorService.scheduleWithFixedDelay(this, 0L, this._refreshEveryNSeconds.get(), TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (!this._running.getAndSet(false) || this._scheduledFuture == null) {
            _log.warn("Segments PeriodicFetching not running...");
            return;
        }
        this._scheduledFuture.cancel(false);
        _log.debug("Stopped PeriodicFetching Segments ...");
    }

    @Override
    public void run() {
        _log.debug("Fetch Segments starting ...");
        this.forceRefreshAll();
    }

    @Override
    public void close() {
        if (this._scheduledExecutorService == null || this._scheduledExecutorService.isShutdown()) {
            return;
        }
        this._scheduledExecutorService.shutdown();
        try {
            if (!this._scheduledExecutorService.awaitTermination(2L, TimeUnit.SECONDS)) {
                _log.info("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = this._scheduledExecutorService.shutdownNow();
                _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            _log.error("Shutdown of SegmentFetchers was interrupted");
            Thread.currentThread().interrupt();
        }
    }
}

