/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.AbstractLocalhostSplitFile;
import io.split.client.LocalhostSplit;
import io.split.client.LocalhostSplitFactory;
import io.split.client.SplitAndKey;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.collect.Maps;

public class LegacyLocalhostSplitFile
extends AbstractLocalhostSplitFile {
    private static final Logger _log = LoggerFactory.getLogger(LegacyLocalhostSplitFile.class);

    public LegacyLocalhostSplitFile(LocalhostSplitFactory splitFactory, String directory, String fileName) throws IOException {
        super(splitFactory, directory, fileName);
    }

    @Override
    public Map<SplitAndKey, LocalhostSplit> readOnSplits() throws IOException {
        HashMap<SplitAndKey, LocalhostSplit> onSplits = Maps.newHashMap();
        try (BufferedReader reader = new BufferedReader(new FileReader(this._file));){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    String[] feature_treatment = line.split("\\s+");
                    if (feature_treatment.length < 2 || feature_treatment.length > 3) {
                        _log.info("Ignoring line since it does not have 2 or 3 columns: " + line);
                    } else {
                        SplitAndKey splitAndKey = null;
                        splitAndKey = feature_treatment.length == 2 ? SplitAndKey.of(feature_treatment[0]) : SplitAndKey.of(feature_treatment[0], feature_treatment[2]);
                        onSplits.put(splitAndKey, new LocalhostSplit(feature_treatment[1], null));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            _log.warn("There was no file named " + this._file.getPath() + " found. We created a split client that returns default treatments for all features for all of your users. If you wish to return a specific treatment for a feature, enter the name of that feature name and treatment name separated by whitespace in " + this._file.getPath() + "; one pair per line. Empty lines or lines starting with '#' are considered comments", (Throwable)e);
        }
        return onSplits;
    }
}

