/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.cache.SplitCache;
import io.split.client.SplitClientConfig;
import io.split.client.SplitManager;
import io.split.client.api.SplitView;
import io.split.engine.SDKReadinessGates;
import io.split.engine.experiments.ParsedSplit;
import io.split.inputValidation.SplitNameValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;

public class SplitManagerImpl
implements SplitManager {
    private static final Logger _log = LoggerFactory.getLogger(SplitManagerImpl.class);
    private final SplitCache _splitCache;
    private final SplitClientConfig _config;
    private final SDKReadinessGates _gates;

    public SplitManagerImpl(SplitCache splitCache, SplitClientConfig config, SDKReadinessGates gates) {
        this._config = Preconditions.checkNotNull(config);
        this._splitCache = Preconditions.checkNotNull(splitCache);
        this._gates = Preconditions.checkNotNull(gates);
    }

    @Override
    public List<SplitView> splits() {
        ArrayList<SplitView> result = new ArrayList<SplitView>();
        Collection<ParsedSplit> parsedSplits = this._splitCache.getAll();
        for (ParsedSplit split : parsedSplits) {
            result.add(SplitView.fromParsedSplit(split));
        }
        return result;
    }

    @Override
    public SplitView split(String featureName) {
        Optional<String> result = SplitNameValidator.isValid(featureName, "split");
        if (!result.isPresent()) {
            return null;
        }
        featureName = result.get();
        ParsedSplit parsedSplit = this._splitCache.get(featureName);
        if (parsedSplit == null) {
            if (this._gates.isSDKReadyNow()) {
                _log.warn("split: you passed \"" + featureName + "\" that does not exist in this environment, please double check what Splits exist in the web console.");
            }
            return null;
        }
        return SplitView.fromParsedSplit(parsedSplit);
    }

    @Override
    public List<String> splitNames() {
        ArrayList<String> result = new ArrayList<String>();
        Collection<ParsedSplit> parsedSplits = this._splitCache.getAll();
        for (ParsedSplit split : parsedSplits) {
            result.add(split.feature());
        }
        return result;
    }

    @Override
    public void blockUntilReady() throws TimeoutException, InterruptedException {
        if (this._config.blockUntilReady() <= 0) {
            throw new IllegalArgumentException("setBlockUntilReadyTimeout must be positive but in config was: " + this._config.blockUntilReady());
        }
        if (!this._gates.isSDKReady(this._config.blockUntilReady())) {
            throw new TimeoutException("SDK was not ready in " + this._config.blockUntilReady() + " milliseconds");
        }
    }
}

