/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import io.split.engine.metrics.Metrics;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class FireAndForgetMetrics
implements Metrics,
Closeable {
    private static final Logger _log = LoggerFactory.getLogger(FireAndForgetMetrics.class);
    private final ExecutorService _executorService;
    private final Metrics _delegate;

    public static FireAndForgetMetrics instance(Metrics delegate, int numberOfThreads, int queueSize) {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        threadFactoryBuilder.setNameFormat("split-fireAndForgetMetrics-%d");
        threadFactoryBuilder.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                _log.error("Error in thread: " + t.getName(), e);
            }
        });
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(numberOfThreads, numberOfThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueSize), threadFactoryBuilder.build(), new ThreadPoolExecutor.DiscardPolicy());
        return new FireAndForgetMetrics(delegate, executorService);
    }

    private FireAndForgetMetrics(Metrics delegate, ExecutorService executorService) {
        this._delegate = delegate;
        this._executorService = executorService;
    }

    @Override
    public void count(String counter, long delta) {
        try {
            this._executorService.submit(new CountRunnable(this._delegate, counter, delta));
        }
        catch (Throwable t) {
            _log.warn("CountRunnable failed", t);
        }
    }

    @Override
    public void time(String operation, long timeInMs) {
        try {
            this._executorService.submit(new TimeRunnable(this._delegate, operation, timeInMs));
        }
        catch (Throwable t) {
            _log.warn("TimeRunnable failed", t);
        }
    }

    @Override
    public void close() {
        this._executorService.shutdown();
        try {
            if (!this._executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                _log.info("Executor did not terminate in the specified time.");
                List<Runnable> droppedTasks = this._executorService.shutdownNow();
                _log.info("Executor was abruptly shut down. These tasks will not be executed: " + droppedTasks);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static final class TimeRunnable
    implements Runnable {
        private final Metrics _delegate;
        private final String _name;
        private final long _timeInMs;

        public TimeRunnable(Metrics delegate, String name, long timeInMs) {
            this._delegate = delegate;
            this._name = name;
            this._timeInMs = timeInMs;
        }

        @Override
        public void run() {
            this._delegate.time(this._name, this._timeInMs);
        }
    }

    private static final class CountRunnable
    implements Runnable {
        private final Metrics _delegate;
        private final String _name;
        private final long _delta;

        public CountRunnable(Metrics delegate, String name, long delta) {
            this._delegate = delegate;
            this._name = name;
            this._delta = delta;
        }

        @Override
        public void run() {
            this._delegate.count(this._name, this._delta);
        }
    }
}

