/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.metrics;

import io.split.client.dtos.Counter;
import io.split.client.dtos.Latency;
import io.split.client.metrics.DTOMetrics;
import io.split.client.utils.Utils;
import io.split.engine.metrics.Metrics;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.annotations.VisibleForTesting;
import split.com.google.common.base.Preconditions;
import split.com.google.common.collect.Lists;

public class HttpMetrics
implements Metrics,
DTOMetrics {
    private static final Logger _log = LoggerFactory.getLogger(HttpMetrics.class);
    private final CloseableHttpClient _client;
    private final URI _timeTarget;
    private final URI _counterTarget;

    public static HttpMetrics create(CloseableHttpClient client, URI root) throws URISyntaxException {
        return new HttpMetrics(client, root);
    }

    public HttpMetrics(CloseableHttpClient client, URI root) throws URISyntaxException {
        Preconditions.checkNotNull(root);
        this._client = Preconditions.checkNotNull(client);
        this._timeTarget = Utils.appendPath(root, "api/metrics/time");
        this._counterTarget = Utils.appendPath(root, "api/metrics/counter");
    }

    @Override
    public void time(Latency dto) {
        if (dto.latencies.isEmpty()) {
            return;
        }
        try {
            this.post(this._timeTarget, dto);
        }
        catch (Throwable t) {
            _log.warn("Exception when posting metric" + dto, t);
        }
    }

    @Override
    public void count(Counter dto) {
        try {
            this.post(this._counterTarget, dto);
        }
        catch (Throwable t) {
            _log.warn("Exception when posting metric" + dto, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(URI uri, Object dto) {
        CloseableHttpResponse response;
        block4: {
            response = null;
            try {
                HttpEntity entity = Utils.toJsonEntity(dto);
                HttpPost request = new HttpPost(uri);
                request.setEntity(entity);
                response = this._client.execute((ClassicHttpRequest)request);
                int status = response.getCode();
                if (status >= 200 && status < 300) break block4;
                _log.warn("Response status was: " + status);
            }
            catch (Throwable t) {
                block5: {
                    try {
                        _log.warn("Exception when posting metrics:" + t.getMessage());
                        if (!_log.isDebugEnabled()) break block5;
                        _log.debug("Reason:", t);
                    }
                    catch (Throwable throwable) {
                        Utils.forceClose(response);
                        throw throwable;
                    }
                }
                Utils.forceClose(response);
            }
        }
        Utils.forceClose(response);
    }

    @Override
    public void count(String counter, long delta) {
        try {
            Counter dto = new Counter();
            dto.name = counter;
            dto.delta = delta;
            this.count(dto);
        }
        catch (Throwable t) {
            _log.info("Could not count metric " + counter, t);
        }
    }

    @Override
    public void time(String operation, long timeInMs) {
        try {
            Latency dto = new Latency();
            dto.name = operation;
            dto.latencies = Lists.newArrayList(timeInMs);
            this.time(dto);
        }
        catch (Throwable t) {
            _log.info("Could not time metric " + operation, t);
        }
    }

    @VisibleForTesting
    URI getTimeTarget() {
        return this._timeTarget;
    }

    @VisibleForTesting
    URI getCounterTarget() {
        return this._counterTarget;
    }
}

