/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.events;

import io.split.client.dtos.Event;
import io.split.client.events.EventsSender;
import io.split.client.events.EventsStorageConsumer;
import io.split.client.events.WrappedEvent;
import io.split.client.utils.SplitExecutorFactory;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class EventsTask {
    private final EventsStorageConsumer _eventsStorageConsumer;
    private final EventsSender _eventsSender;
    private final long _sendIntervalMillis;
    private final ScheduledExecutorService _senderScheduledExecutorService;
    private static final Logger _log = LoggerFactory.getLogger(EventsTask.class);

    public static EventsTask create(long sendIntervalMillis, EventsStorageConsumer eventsStorageConsumer, EventsSender eventsSender, ThreadFactory threadFactory) throws URISyntaxException {
        return new EventsTask(eventsStorageConsumer, sendIntervalMillis, eventsSender, threadFactory);
    }

    EventsTask(EventsStorageConsumer eventsStorageConsumer, long sendIntervalMillis, EventsSender eventsSender, ThreadFactory threadFactory) {
        this._eventsStorageConsumer = Preconditions.checkNotNull(eventsStorageConsumer);
        this._sendIntervalMillis = sendIntervalMillis;
        this._eventsSender = Preconditions.checkNotNull(eventsSender);
        this._senderScheduledExecutorService = SplitExecutorFactory.buildSingleThreadScheduledExecutor(threadFactory, "Sender-events-%d");
    }

    ThreadFactory eventClientThreadFactory(String name) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name).build();
    }

    public void start() {
        this._senderScheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this.sendEvents();
            }
            catch (Exception e) {
                _log.error("Error executing Event Action", (Throwable)e);
            }
        }, this._sendIntervalMillis, this._sendIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void close() {
        try {
            this.sendEvents();
            this._senderScheduledExecutorService.shutdown();
        }
        catch (Exception e) {
            _log.warn("Error when shutting down EventClientImpl", (Throwable)e);
        }
    }

    void sendEvents() {
        if (this._eventsStorageConsumer.isFull()) {
            _log.warn("Split SDK events queue is full. Events may have been dropped. Consider increasing capacity.");
        }
        List<WrappedEvent> wrappedEventList = this._eventsStorageConsumer.popAll();
        ArrayList<Event> eventsToSend = new ArrayList<Event>();
        for (WrappedEvent wrappedEvent : wrappedEventList) {
            Event event = wrappedEvent.event();
            eventsToSend.add(event);
        }
        if (eventsToSend.isEmpty()) {
            return;
        }
        this._eventsSender.sendEvents(eventsToSend);
    }
}

