/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import io.split.client.interceptors.FlagSetsFilter;
import java.util.Set;

public class FlagSetsFilterImpl
implements FlagSetsFilter {
    private final Set<String> _flagSets;
    private final boolean _shouldFilter;

    public FlagSetsFilterImpl(Set<String> flagSets) {
        this._shouldFilter = !flagSets.isEmpty();
        this._flagSets = flagSets;
    }

    @Override
    public boolean intersect(Set<String> sets) {
        if (!this._shouldFilter) {
            return true;
        }
        if (sets == null || sets.isEmpty()) {
            return false;
        }
        for (String set : sets) {
            if (!this._flagSets.contains(set)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersect(String set) {
        if (!this._shouldFilter) {
            return true;
        }
        if (set.isEmpty()) {
            return false;
        }
        return this._flagSets.contains(set);
    }
}

