/*
 * Decompiled with CFR 0.152.
 */
package split.com.google.common.util.concurrent;

import javax.annotation.CheckForNull;
import split.com.google.common.annotations.GwtCompatible;
import split.com.google.common.base.Preconditions;
import split.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t2, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t2);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t2) {
        Preconditions.checkNotNull(t2);
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

