/*
 * Decompiled with CFR 0.152.
 */
package io.split.client.interceptors;

import java.io.IOException;
import split.com.google.common.base.Preconditions;
import split.org.apache.hc.core5.http.EntityDetails;
import split.org.apache.hc.core5.http.HttpException;
import split.org.apache.hc.core5.http.HttpRequest;
import split.org.apache.hc.core5.http.HttpRequestInterceptor;
import split.org.apache.hc.core5.http.protocol.HttpContext;

public class AuthorizationInterceptorFilter
implements HttpRequestInterceptor {
    static final String AUTHORIZATION_HEADER = "Authorization";
    private final String _apiTokenBearer;

    public static AuthorizationInterceptorFilter instance(String apiToken) {
        return new AuthorizationInterceptorFilter(apiToken);
    }

    private AuthorizationInterceptorFilter(String apiToken) {
        this._apiTokenBearer = "Bearer " + Preconditions.checkNotNull(apiToken);
    }

    @Override
    public void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
        httpRequest.addHeader(AUTHORIZATION_HEADER, this._apiTokenBearer);
    }
}

