/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.matchers;

import io.split.engine.evaluator.EvaluationContext;
import io.split.engine.matchers.Matcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DependencyMatcher
implements Matcher {
    private String _featureFlag;
    private List<String> _treatments;

    public DependencyMatcher(String featureFlag, List<String> treatments) {
        this._featureFlag = featureFlag;
        this._treatments = treatments;
    }

    @Override
    public boolean match(Object matchValue, String bucketingKey, Map<String, Object> attributes, EvaluationContext evaluationContext) {
        if (matchValue == null) {
            return false;
        }
        if (!(matchValue instanceof String)) {
            return false;
        }
        String result = evaluationContext.getEvaluator().evaluateFeature((String)((String)matchValue), (String)bucketingKey, (String)this._featureFlag, attributes).treatment;
        return this._treatments.contains(result);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("in split \"");
        bldr.append(this._featureFlag);
        bldr.append("\" treatment ");
        bldr.append(this._treatments);
        return bldr.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyMatcher that = (DependencyMatcher)o;
        if (!Objects.equals(this._featureFlag, that._featureFlag)) {
            return false;
        }
        return Objects.equals(this._treatments, that._treatments);
    }

    public int hashCode() {
        int result = this._featureFlag != null ? this._featureFlag.hashCode() : 0;
        result = 31 * result + (this._treatments != null ? this._treatments.hashCode() : 0);
        return result;
    }
}

