/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.dtos.SegmentChange;
import io.split.client.utils.Json;
import io.split.client.utils.LocalhostSanitizer;
import io.split.engine.common.FetchOptions;
import io.split.engine.segments.SegmentChangeFetcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.gson.stream.JsonReader;

public class LocalhostSegmentChangeFetcher
implements SegmentChangeFetcher {
    private static final Logger _log = LoggerFactory.getLogger(LocalhostSegmentChangeFetcher.class);
    private final File _file;
    private Map lastHash;

    public LocalhostSegmentChangeFetcher(String filePath) {
        this._file = new File(filePath);
        this.lastHash = new HashMap();
    }

    @Override
    public SegmentChange fetch(String segmentName, long changesSinceThisChangeNumber, FetchOptions options) {
        try {
            JsonReader jsonReader = new JsonReader(new FileReader(String.format("%s/%s.json", this._file, segmentName)));
            SegmentChange segmentChange = Json.fromJson(jsonReader, SegmentChange.class);
            return this.processSegmentChange(segmentName, changesSinceThisChangeNumber, segmentChange);
        }
        catch (FileNotFoundException f) {
            _log.warn(String.format("There was no file named %s/%s found.", this._file.getPath(), segmentName), (Throwable)f);
            throw new IllegalStateException(String.format("Problem fetching segment %s: %s", segmentName, f.getMessage()), f);
        }
        catch (Exception e) {
            _log.warn(String.format("Problem to fetch segment change for the segment %s in the directory %s.", segmentName, this._file.getPath()), (Throwable)e);
            throw new IllegalStateException(String.format("Problem fetching segment %s: %s", segmentName, e.getMessage()), e);
        }
    }

    private SegmentChange processSegmentChange(String segmentName, long changeNumber, SegmentChange segmentChange) throws NoSuchAlgorithmException {
        SegmentChange segmentChangeToProcess = LocalhostSanitizer.sanitization(segmentChange);
        if (segmentChangeToProcess == null) {
            return null;
        }
        if (segmentChangeToProcess.till < changeNumber && segmentChangeToProcess.till != -1L) {
            _log.warn("The segmentChange till is lower than the change number or different to -1");
            return null;
        }
        String toHash = segmentChangeToProcess.added.toString() + segmentChangeToProcess.removed.toString();
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(toHash.getBytes());
        byte[] currHash = digest.digest();
        if (this.lastHash.containsKey(segmentName) && Arrays.equals((byte[])this.lastHash.get(segmentName), currHash) || segmentChangeToProcess.till == -1L) {
            segmentChangeToProcess.till = changeNumber;
        }
        this.lastHash.put(segmentName, currHash);
        segmentChangeToProcess.since = changeNumber;
        return segmentChangeToProcess;
    }
}

