/*
 * Decompiled with CFR 0.152.
 */
package io.split.client;

import io.split.client.CustomHeaderDecorator;
import io.split.client.NoOpHeaderDecorator;
import io.split.client.dtos.RequestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import split.org.apache.hc.core5.http.Header;
import split.org.apache.hc.core5.http.HttpRequest;

public final class RequestDecorator {
    CustomHeaderDecorator _headerDecorator;
    private static final Set<String> forbiddenHeaders = new HashSet<String>(Arrays.asList("splitsdkversion", "splitmachineip", "splitmachinename", "splitimpressionsmode", "host", "referrer", "content-type", "content-length", "content-encoding", "accept", "keep-alive", "x-fastly-debug"));

    public RequestDecorator(CustomHeaderDecorator headerDecorator) {
        this._headerDecorator = headerDecorator == null ? new NoOpHeaderDecorator() : headerDecorator;
    }

    public HttpRequest decorateHeaders(HttpRequest request) {
        try {
            Map<String, List<String>> headers = this._headerDecorator.getHeaderOverrides(new RequestContext(this.convertToMap(request.getHeaders())));
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                if (!this.isHeaderAllowed(entry.getKey())) continue;
                List<String> values = entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    if (i == 0) {
                        request.setHeader(entry.getKey(), values.get(i));
                        continue;
                    }
                    request.addHeader(entry.getKey(), values.get(i));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Problem adding custom headers to request decorator: %s", e), e);
        }
        return request;
    }

    private boolean isHeaderAllowed(String headerName) {
        return !forbiddenHeaders.contains(headerName.toLowerCase());
    }

    private Map<String, List<String>> convertToMap(Header[] to_convert) {
        HashMap<String, List<String>> to_return = new HashMap<String, List<String>>();
        Integer i = 0;
        while (i < to_convert.length) {
            if (!to_return.containsKey(to_convert[i].getName())) {
                to_return.put(to_convert[i].getName(), new ArrayList());
            }
            ((List)to_return.get(to_convert[i].getName())).add(to_convert[i].getValue());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return to_return;
    }
}

