/*
 * Decompiled with CFR 0.152.
 */
package io.split.engine.sse;

import io.split.client.dtos.SplitHttpResponse;
import io.split.client.utils.Json;
import io.split.engine.common.FetchOptions;
import io.split.engine.sse.AuthApiClient;
import io.split.engine.sse.dtos.AuthenticationResponse;
import io.split.engine.sse.dtos.RawAuthResponse;
import io.split.service.SplitHttpClient;
import io.split.telemetry.domain.enums.HTTPLatenciesEnum;
import io.split.telemetry.domain.enums.LastSynchronizationRecordsEnum;
import io.split.telemetry.storage.TelemetryRuntimeProducer;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.com.google.common.base.Preconditions;
import split.com.google.gson.JsonObject;
import split.org.apache.hc.core5.net.URIBuilder;

public class AuthApiClientImp
implements AuthApiClient {
    private static final Logger _log = LoggerFactory.getLogger(AuthApiClientImp.class);
    private static final String SPEC = "s";
    private final SplitHttpClient _httpClient;
    private final String _target;
    private final TelemetryRuntimeProducer _telemetryRuntimeProducer;

    public AuthApiClientImp(String url, SplitHttpClient httpClient, TelemetryRuntimeProducer telemetryRuntimeProducer) {
        this._httpClient = Preconditions.checkNotNull(httpClient);
        this._target = Preconditions.checkNotNull(url);
        this._telemetryRuntimeProducer = Preconditions.checkNotNull(telemetryRuntimeProducer);
    }

    @Override
    public AuthenticationResponse Authenticate() {
        try {
            long initTime = System.currentTimeMillis();
            URI uri = new URIBuilder(this._target).addParameter(SPEC, "1.1").build();
            SplitHttpResponse response = this._httpClient.get(uri, new FetchOptions.Builder().cacheControlHeaders(false).build(), null);
            Integer statusCode = response.statusCode();
            if (statusCode == 200) {
                _log.debug(String.format("Success connection to: %s", this._target));
                this._telemetryRuntimeProducer.recordTokenRefreshes();
                this._telemetryRuntimeProducer.recordSuccessfulSync(LastSynchronizationRecordsEnum.TOKEN, System.currentTimeMillis());
                this._telemetryRuntimeProducer.recordSyncLatency(HTTPLatenciesEnum.TOKEN, System.currentTimeMillis() - initTime);
                return this.getSuccessResponse(response.body());
            }
            _log.error(String.format("Problem to connect to : %s. Response status: %s", this._target, statusCode));
            if (statusCode >= 400 && statusCode < 500) {
                if (statusCode == 401) {
                    this._telemetryRuntimeProducer.recordAuthRejections();
                }
                return new AuthenticationResponse(false, false);
            }
            return new AuthenticationResponse(false, true);
        }
        catch (Exception ex) {
            _log.error(ex.getMessage());
            return new AuthenticationResponse(false, true);
        }
    }

    private AuthenticationResponse getSuccessResponse(String jsonContent) {
        JsonObject jsonObject = Json.fromJson(jsonContent, JsonObject.class);
        String token = jsonObject.get("token") != null ? jsonObject.get("token").getAsString() : "";
        RawAuthResponse response = new RawAuthResponse(jsonObject.get("pushEnabled").getAsBoolean(), token);
        String channels = "";
        long expiration = 0L;
        if (response.isPushEnabled()) {
            channels = response.getChannels();
            expiration = response.getExpiration();
        }
        return new AuthenticationResponse(response.isPushEnabled(), response.getToken(), channels, expiration, false);
    }
}

