/*
 * Decompiled with CFR 0.152.
 */
package io.split.service;

import io.split.client.RequestDecorator;
import io.split.client.dtos.SplitHttpResponse;
import io.split.client.utils.SDKMetadata;
import io.split.client.utils.Utils;
import io.split.engine.common.FetchOptions;
import io.split.service.SplitHttpClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import split.org.apache.hc.client5.http.classic.methods.HttpGet;
import split.org.apache.hc.client5.http.classic.methods.HttpPost;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import split.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import split.org.apache.hc.core5.http.HttpEntity;
import split.org.apache.hc.core5.http.HttpRequest;
import split.org.apache.hc.core5.http.io.entity.EntityUtils;

public final class SplitHttpClientImpl
implements SplitHttpClient {
    private static final Logger _log = LoggerFactory.getLogger(SplitHttpClient.class);
    private static final String HEADER_CACHE_CONTROL_NAME = "Cache-Control";
    private static final String HEADER_CACHE_CONTROL_VALUE = "no-cache";
    private static final String HEADER_API_KEY = "Authorization";
    private static final String HEADER_CLIENT_KEY = "SplitSDKClientKey";
    private static final String HEADER_CLIENT_MACHINE_NAME = "SplitSDKMachineName";
    private static final String HEADER_CLIENT_MACHINE_IP = "SplitSDKMachineIP";
    private static final String HEADER_CLIENT_VERSION = "SplitSDKVersion";
    private final CloseableHttpClient _client;
    private final RequestDecorator _requestDecorator;
    private final String _apikey;
    private final SDKMetadata _metadata;

    public static SplitHttpClientImpl create(CloseableHttpClient client, RequestDecorator requestDecorator, String apikey, SDKMetadata metadata) throws URISyntaxException {
        return new SplitHttpClientImpl(client, requestDecorator, apikey, metadata);
    }

    private SplitHttpClientImpl(CloseableHttpClient client, RequestDecorator requestDecorator, String apikey, SDKMetadata metadata) {
        this._client = client;
        this._requestDecorator = requestDecorator;
        this._apikey = apikey;
        this._metadata = metadata;
    }

    @Override
    public SplitHttpResponse get(URI uri, FetchOptions options, Map<String, List<String>> additionalHeaders) {
        SplitHttpResponse splitHttpResponse;
        CloseableHttpResponse response = null;
        try {
            HttpGet request = new HttpGet(uri);
            this.setBasicHeaders(request);
            if (additionalHeaders != null) {
                for (Map.Entry<String, List<String>> entry : additionalHeaders.entrySet()) {
                    for (String value : entry.getValue()) {
                        request.addHeader(entry.getKey(), value);
                    }
                }
            }
            if (options.cacheControlHeadersEnabled()) {
                request.setHeader(HEADER_CACHE_CONTROL_NAME, HEADER_CACHE_CONTROL_VALUE);
            }
            this._requestDecorator.decorateHeaders(request);
            response = this._client.execute(request);
            if (_log.isDebugEnabled()) {
                _log.debug(String.format("[%s] %s. Status code: %s", request.getMethod(), uri.toURL(), response.getCode()));
            }
            String statusMessage = "";
            if (response.getCode() < 200 || response.getCode() >= 300) {
                _log.warn(String.format("Response status was: %s. Reason: %s", response.getCode(), response.getReasonPhrase()));
                statusMessage = response.getReasonPhrase();
            }
            splitHttpResponse = new SplitHttpResponse(response.getCode(), statusMessage, EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8), response.getHeaders());
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(String.format("Problem in http get operation: %s", e), e);
            }
            catch (Throwable throwable) {
                Utils.forceClose(response);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        return splitHttpResponse;
    }

    @Override
    public SplitHttpResponse post(URI uri, HttpEntity entity, Map<String, List<String>> additionalHeaders) throws IOException {
        SplitHttpResponse splitHttpResponse;
        CloseableHttpResponse response = null;
        try {
            HttpPost request = new HttpPost(uri);
            this.setBasicHeaders(request);
            if (additionalHeaders != null) {
                for (Map.Entry<String, List<String>> entry : additionalHeaders.entrySet()) {
                    for (String value : entry.getValue()) {
                        request.addHeader(entry.getKey(), value);
                    }
                }
            }
            request.setEntity(entity);
            request = (HttpPost)this._requestDecorator.decorateHeaders(request);
            response = this._client.execute(request);
            String statusMessage = "";
            if (response.getCode() < 200 || response.getCode() >= 300) {
                statusMessage = response.getReasonPhrase();
                _log.warn(String.format("Response status was: %s. Reason: %s", response.getCode(), response.getReasonPhrase()));
            }
            splitHttpResponse = new SplitHttpResponse(response.getCode(), statusMessage, "", response.getHeaders());
        }
        catch (Exception e) {
            try {
                throw new IOException(String.format("Problem in http post operation: %s", e), e);
            }
            catch (Throwable throwable) {
                Utils.forceClose(response);
                throw throwable;
            }
        }
        Utils.forceClose(response);
        return splitHttpResponse;
    }

    private void setBasicHeaders(HttpRequest request) {
        request.setHeader(HEADER_API_KEY, "Bearer " + this._apikey);
        request.setHeader(HEADER_CLIENT_VERSION, this._metadata.getSdkVersion());
        request.setHeader(HEADER_CLIENT_MACHINE_IP, this._metadata.getMachineIp());
        request.setHeader(HEADER_CLIENT_MACHINE_NAME, this._metadata.getMachineName());
        request.setHeader(HEADER_CLIENT_KEY, this._apikey.length() > 4 ? this._apikey.substring(this._apikey.length() - 4) : this._apikey);
    }

    @Override
    public void close() throws IOException {
        this._client.close();
    }
}

